% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pair_minsim.R
\name{pair_minsim}
\alias{pair_minsim}
\title{Generate pairs with a minimal similarity}
\usage{
pair_minsim(
  x,
  y,
  on,
  minsim = 0,
  on_blocking = character(0),
  comparators = list(default_comparator),
  default_comparator = cmp_identical(),
  keep_simsum = TRUE,
  deduplication = FALSE,
  add_xy = TRUE
)
}
\arguments{
\item{x}{first \code{data.frame}}

\item{y}{second \code{data.frame}. Ignored when \code{deduplication = TRUE}.}

\item{on}{the variables defining on which the pairs of records from \code{x} 
and \code{y} are compared.}

\item{minsim}{minimal similarity score.}

\item{on_blocking}{variables for which the pairs have to match.}

\item{comparators}{named list of functions with which the variables are compared. 
This function should accept two vectors. Function should either return a vector
or a \code{data.table} with multiple columns.}

\item{default_comparator}{variables for which no comparison function is defined using
\code{comparators} is compares with the function \code{default_comparator}.}

\item{keep_simsum}{add a variable \code{minsim} to the result with the similarity 
score of the pair.}

\item{deduplication}{generate pairs from only \code{x}. Ignore \code{y}. This 
is usefull for deduplication of \code{x}.}

\item{add_xy}{add \code{x} and \code{y} as attributes to the returned 
pairs. This makes calling some subsequent operations that need \code{x} and 
\code{y} (such as \code{\link{compare_pairs}} easier.}
}
\value{
A \code{\link{data.table}} with two columns, 
\code{.x} and \code{.y}, is returned. Columns \code{.x} and \code{.y} are 
row numbers from \code{data.frame}s \code{.x} and \code{.y} respectively.
}
\description{
Generates all combinations of records from \code{x} and \code{y} where the 
blocking variables are equal.
}
\details{
Generating (all) pairs of the records of two data sets, is usually the first 
step when linking the two data sets. However, this often results in a too 
large number of records. \code{pair_minsim} will only keep pairs with a 
similarity score equal or larger than \code{minsim}. The similarity score is
calculated by summing the results of the comparators for all variables 
of \code{on}.

Missing values in the variables on which the pairs are compared count as a 
similarity of 0.
}
\examples{
data("linkexample1", "linkexample2")
pairs <- pair_minsim(linkexample1, linkexample2, 
   on = c("postcode", "address"), minsim = 1)
# Either address or postcode has to match to keep a pair

data("linkexample1", "linkexample2")
pairs <- pair_minsim(linkexample1, linkexample2, on_blocking = "postcode",
   on = c("lastname", "firstname", "address"), minsim = 2)
# Postcode has to match; from lastname, firstname, address there have to match
# two or more (e.g. one mismatch is allowed).

}
\seealso{
\code{\link{pair}} and \code{\link{pair_blocking}} are other methods
to generate pairs.
}
