% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotorious.R
\name{annotorious-shiny}
\alias{annotorious-shiny}
\alias{annotoriousOutput}
\alias{renderAnnotorious}
\title{Shiny bindings for annotorious}
\usage{
annotoriousOutput(outputId, width = "100\%", height = "400px")

renderAnnotorious(expr, env = parent.frame(), quoted = FALSE)
}
\arguments{
\item{outputId}{output variable to read from}

\item{width, height}{Must be a valid CSS unit (like \code{'100\%'},
\code{'400px'}, \code{'auto'}) or a number, which will be coerced to a
string and have \code{'px'} appended.}

\item{expr}{An expression that generates a annotorious}

\item{env}{The environment in which to evaluate \code{expr}.}

\item{quoted}{Is \code{expr} a quoted expression (with \code{quote()})? This
is useful if you want to save an expression in a variable.}
}
\value{
An output element for use in a Shiny user interface.\cr
Consisting of a toggle button to switch between rectangle / polygon mode (id: \code{outputId}\code{-toggle}) and
the html-widget (id: \code{outputId}) which contains an image (id: \code{outputId}\code{-img})
}
\description{
Output and render functions for using annotorious within Shiny
applications and interactive Rmd documents.
}
\examples{
if(interactive() && require(shiny)){
library(shiny)
library(recogito)
url <- paste("https://upload.wikimedia.org/",
             "wikipedia/commons/a/a0/Pamphlet_dutch_tulipomania_1637.jpg",
             sep = "")
ui <- fluidPage(annotoriousOutput(outputId = "anno"),
                tags$hr(),
                tags$h3("Results"),
                verbatimTextOutput(outputId = "annotation_result"))
server <- function(input, output) {
  output$anno <- renderAnnotorious({
    annotorious("annotations", tags = c("IMAGE", "TEXT"), src = url)
  })
  output$annotation_result <- renderPrint({
    read_annotorious(input$annotations)
  })
}
shinyApp(ui, server)

}


annotoriousOutput(outputId = "anno")
}
