% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FileMetadata.R
\docType{methods}
\name{initialize,FileMetadata-method}
\alias{initialize,FileMetadata-method}
\alias{initialize-FileMetadata}
\title{Initialize a file metadata object.}
\usage{
\S4method{initialize}{FileMetadata}(.Object, file, fileId = as.character(NA),
  sha256 = as.character(NA), size = as.numeric(0),
  user = as.character(NA), createTime = as.character(NA),
  modifyTime = as.character(NA), executionId, access = as.character(NA),
  format = as.character(NA), archivedFilePath = as.character(NA))
}
\arguments{
\item{.Object}{a \code{"FileMetdata"} object}

\item{file}{a \code{"character"}, a file to acquire metadata for}

\item{fileId}{a \code{"character"}, the unique identifier for this FileMeta object}

\item{sha256}{a \code{"character"}, the checksum for the file}

\item{size}{a \code{"numeric"}, size in bytes of the file}

\item{user}{a \code{"character"}, the user that owns the file}

\item{createTime}{a \code{"character"}, the creation time of the file}

\item{modifyTime}{a \code{"character"}, the modification time of the file}

\item{executionId}{a \code{"character"}, the executionId associated with this FileMeatadata object}

\item{access}{\code{"character"}, the access that occurred for this file ("read", "write", "execute")}

\item{format}{a \code{"character"}, the format type associate with the file, e.g. "text/csv"}

\item{archivedFilePath}{a \code{"character"}, the file path of the file}
}
\description{
Initialize a file metadata object.
}
\details{
This method is used internally by the recordr package.
}
\seealso{
\code{\link[=FileMetadata-class]{FileMetadata}} { class description}
}

