% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Recordr.R
\docType{methods}
\name{record}
\alias{record}
\alias{record,Recordr-method}
\title{Record data provenance for an R script exection}
\usage{
record(recordr, file, ...)

\S4method{record}{Recordr}(recordr, file, tag = "", ...)
}
\arguments{
\item{recordr}{a Recordr instance}

\item{file}{The name of the R script to run and collect provenance information for}

\item{...}{additional parameters that will be passed to the R \code{"base::source()"} function}

\item{tag}{A string that will be associated with this run}
}
\value{
The execution identifier for this run
}
\description{
The R script is executed and information about file reads and writes
is recorded.
}
\details{
Input files, the script itself and igenerated files are archived.
Information about the execution environment is also saved.
}
\examples{
\dontrun{
rc <- new("Recordr")
executionId <- record(rc, file="myscript.R", tag="first run of myscript.R")
}
}
\seealso{
\code{\link[=Recordr-class]{Recordr}} { class description}
}

