% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drawCircle.R
\name{drawCircle}
\alias{drawCircle}
\title{Draws a circle}
\usage{
drawCircle(x, y, radius, nv = 100, border = NULL, col = NA, lty = 1,
  lwd = 1)
}
\arguments{
\item{x}{x-coordinate of circle center}

\item{y}{y-coordinate of circle center}

\item{radius}{radius of circle}

\item{nv}{how many plotted segments}

\item{border}{polygon border}

\item{col}{line color}

\item{lty}{line type}

\item{lwd}{line width}
}
\value{
invisibly, the x and y points of the drawn circle
}
\description{
Draws a circle in data coordinates, so it will be a circle if the aspect
ratio of the plot is 1, or else it will be appear as an ellipse.
}
\details{
This function is useful to display a representative circle with the specified radius
on a plot of revisits.
}
\examples{
data(martin)
revisits = getRecursions(martin, radius = 1)
plot(revisits, martin, legendPos = c(10, -15))
drawCircle(10, -10, 1)

}
\seealso{
\code{\link{plot.recurse}}
}
\author{
Chloe Bracis <cbracis@uw.edu>
}
