% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docsRecordsManagementMethods.R,
%   R/exportNextRecordName.R, R/renameRecord.R
\name{recordsManagementMethods}
\alias{recordsManagementMethods}
\alias{exportNextRecordName}
\alias{renameRecord}
\alias{exportNextRecordName.redcapApiConnection}
\alias{renameRecord.redcapApiConnection}
\title{Export Next Record Name or Rename a Record}
\usage{
exportNextRecordName(rcon, ...)

renameRecord(rcon, record_name, new_record_name, arm = NULL, ...)

\method{exportNextRecordName}{redcapApiConnection}(rcon, ...)

\method{renameRecord}{redcapApiConnection}(rcon, record_name, new_record_name, arm = NULL, ...)
}
\arguments{
\item{rcon}{A \code{redcapConnection} object.}

\item{record_name}{\code{character(1)} or \code{integerish(1)}.
The name of an existing record in the project.}

\item{new_record_name}{\code{character(1)} or \code{integerish(1)}.
The new name to give to the record.}

\item{arm}{\code{character(1)} or \code{NULL}, an optional arm number.
If \code{NULL}, then all records with same name across all arms on
which it exists (if longitudinal with multiple arms) will be
renamed to new record name, otherwise it will rename the record
only in the specified arm.}

\item{...}{Arguments to pass to other methods}
}
\value{
\code{exportNextRecordName} returns an integerish value. The value is
determined by looking up the highest record ID number in the
project and incrementing it by 1.

\code{renameRecord} invisibly returns a logical value that indicates if the
operation was successful. Otherwise, an error is thrown.
}
\description{
These methods enable the user to get the next record name
(when auto numbering is enabled) or rename and existing record.
}
\section{Functions}{
\itemize{
\item \code{exportNextRecordName()}: Get the ID number for the next record to be created.

\item \code{renameRecord()}: Rename an existing record.

}}
\examples{
\dontrun{
unlockREDCap(connections = c(rcon = "project_alias"), 
             url = "your_redcap_url", 
             keyring = "API_KEYs", 
             envir = globalenv())
             
# Get the next record name
exportNextRecordName(rcon)

# Rename an existing record
renameRecord(rcon, 
             record_name = "1", 
             new_record_name = "42")
}

}
\seealso{
\code{\link[=exportRecords]{exportRecords()}}, \cr
\code{\link[=exportReports]{exportReports()}}, \cr
\code{\link[=importRecords]{importRecords()}}, \cr
\code{\link[=deleteRecords]{deleteRecords()}}, \cr
\code{\link[=exportRecordsTyped]{exportRecordsTyped()}}, \cr
\code{\link[=exportReportsTyped]{exportReportsTyped()}}
}
