% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exportExternalCoding.R
\name{exportExternalCoding}
\alias{exportExternalCoding}
\alias{exportExternalCoding.redcapApiConnection}
\title{Export Codebook Mappings for Fields with External Dependencies}
\usage{
exportExternalCoding(rcon, fields, ...)

\method{exportExternalCoding}{redcapApiConnection}(rcon, fields = NULL, ..., batch_size = 1000)
}
\arguments{
\item{rcon}{A \code{redcapConnection} object.}

\item{fields}{\code{character} or \code{NULL}. Vector of fields to be returned.  If \code{NULL},
all fields are returned (unless \code{forms} is specified).}

\item{...}{Arguments to pass to other methods}

\item{batch_size}{\code{integerish(1)} or \code{NULL}. When \code{NULL},
all records are pulled. Otherwise, the records all pulled in batches of this size.}
}
\value{
Returns a named list of named character vectors.

Each element is in the list is named for the field it maps.

The character vectors are name-value pairs where the name is the labeled
data and the value is the coded data.
}
\description{
These methods enable \code{redcapAPI} to obtain a mapping of
codes and associated labels for fields that have external dependencies.
The fields include SQL fields (dependent on another project) or
fields that utilize the BioPortal Ontology modules.
}
\details{
These methods operate by executing two API calls to export first the
coded values and then the labeled values of fields with external
dependencies. The two exports are then used to generate the code-label
mappings for use in casting data.

Fields of type \code{sql} are dropdown fields that are populated by a SQL
query to another project.

Fields of type \code{bioportal} are text fields that have the BioPortal
Ontology module enabled as the validation method.
}
\examples{
\dontrun{
unlockREDCap(connections = c(rcon = "project_alias"), 
             url = "your_redcap_url", 
             keyring = "API_KEYs", 
             envir = globalenv())
             
exportExternalCoding(rcon)
}
  
}
