% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exportRecordsTyped.R
\name{exportBulkRecords}
\alias{exportBulkRecords}
\title{A helper function to export multiple records and forms using
a single call.}
\usage{
exportBulkRecords(
  lcon,
  forms = NULL,
  envir = NULL,
  sep = "_",
  post = NULL,
  ...
)
}
\arguments{
\item{lcon}{A named list of connections. The name is used as a prefix for data.frame
names in the environment specified. It may also be used as a reference from the
forms argument.}

\item{forms}{A named list that is a subset of rcon's names. A specified \code{rcon}
will provide a list of forms for repeated calls to \code{exportRecordsType}.
If a connection reference is missing it will default to all forms. To override
this default specify a connection's forms with NA to just get all
data.}

\item{envir}{A environment to write the resulting Records in as variables
given by their name in rcon or if from a form their rcon named pasted to
their form name joined by \code{sep}. If not specified the function
will return a named list with the results. Will accept a number of the
environment.}

\item{sep}{A character string to use when joining the rcon name to the form name
for storing variables.}

\item{post}{A function that will run on all returned sets of Records.}

\item{\dots}{Any additional variables to pass to \code{\link[=exportRecordsTyped]{exportRecordsTyped()}}.}
}
\value{
Will return a named list of the resulting records if \code{envir} is
NULL. Otherwise will assign them to the specified \code{envir}.
}
\description{
Exports records from multiple REDCap Databases using
multiple calls to \code{\link[=exportRecordsTyped]{exportRecordsTyped()}}
}
\examples{
\dontrun{
unlockREDCap(c(test_conn    = 'TestRedcapAPI',
               sandbox_conn = 'SandboxAPI'),
             keyring      = 'MyKeyring',
             envir        = globalenv(),
             url          = 'https://<REDCAP_URL>/api/') 

# After user interaction to unlock the local encrypted keyring
# the global environment will contain the REDCap connections
# `test_conn` and `sandbox_conn`
# 
# Next the user wants to bulk specify importing all the forms
# of interest and post process

exportBulkRecords(
 rcon  = list(test = test_conn,
              sand = sandbox_conn),
 forms = list(test = c('form1', 'form2'),
 envir = globalenv(),
 post  = function(Records, rcon)
         {
           Records              |>
           mChoiceCast(rcon)    |>
           guessDat(rcon)       |>
           widerRepeating(rcon)
         }
 )
 
# The environment now contains the data.frames: `test.form1`, `test.form2`, `sand`.
# Each of these were retrieved, possibly using the forms argument and all were
# post processed in the same manner as specified by `post`.
}
}
\seealso{
\subsection{Other records exporting functions}{

\code{\link[=exportRecordsTyped]{exportRecordsTyped()}}, \cr
\code{\link[=exportRecords]{exportRecords()}}, \cr
\code{\link[=exportReports]{exportReports()}}
}

\subsection{Field validations and casting}{

\code{\link[=fieldValidationAndCasting]{fieldValidationAndCasting()}}, \cr
\code{\link[=reviewInvalidRecords]{reviewInvalidRecords()}}
}

\subsection{Post-processing functionality}{

\code{\link[=recastRecords]{recastRecords()}}, \cr
\code{\link[=guessCast]{guessCast()}}, \cr
\code{\link[=guessDate]{guessDate()}}, \cr
\code{\link[=castForImport]{castForImport()}}, \cr
\code{\link[=mChoiceCast]{mChoiceCast()}}, \cr
\code{\link[=splitForms]{splitForms()}}, \cr
\code{\link[=widerRepeated]{widerRepeated()}}
}

\subsection{Vignettes}{

\code{vignette("redcapAPI-offline-connection")}\cr
\code{vignette("redcapAPI-casting-data")}\cr
\code{vignette("redcapAPI-missing-data-detection")}\cr
\verb{vignette("redcapAPI-data-validation)}\cr
\verb{vignette("redcapAPI-faq)}
}
}
