% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exportLogging.R
\name{exportLogging}
\alias{exportLogging}
\alias{exportLogging.redcapApiConnection}
\title{Export Logging Records}
\usage{
exportLogging(
  rcon,
  logtype = character(0),
  user = character(0),
  record = character(0),
  dag = character(0),
  beginTime = .POSIXct(character(0)),
  endTime = .POSIXct(character(0)),
  ...
)

\method{exportLogging}{redcapApiConnection}(
  rcon,
  logtype = character(0),
  user = character(0),
  record = character(0),
  dag = character(0),
  beginTime = as.POSIXct(character(0)),
  endTime = as.POSIXct(character(0)),
  ...,
  error_handling = getOption("redcap_error_handling"),
  config = list(),
  api_param = list()
)
}
\arguments{
\item{rcon}{A REDCap connection object as created by \code{redcapConnection}.}

\item{logtype}{\code{character} with maximum length of 1. The log event types to export. By 
default, all event types are exported. Must be one of
\code{c("export", "manage", "user", "record", "record_add", "record_edit", "record_delete", "lock_record", "page_view")}}

\item{user}{\code{character} with maximum length of 1. Users for whom to return logs. By default
logs for all users are returned.}

\item{record}{\code{character} with maximum length of 1. Record ID for which logs are to be returned.
By default, logs are returned for all records.}

\item{dag}{\code{character} with maximum length of 1. Data access group ID for which to return logs. 
By default, logs are returned for all data access groups.}

\item{beginTime}{\code{POSIXct} with maximum length 1. When given, only 
logs recorded after this time will be returned.}

\item{endTime}{\code{POSIXct} with maximum length 1. When given, only logs
recorded before this time will be returned.}

\item{...}{Additional arguments to be passed between methods}

\item{error_handling}{An option for how to handle errors returned by the API.
see \code{\link{redcap_error}}}

\item{config}{\code{list} Additional configuration parameters to pass to 
\code{\link[httr]{POST}}. These are appended to any parameters in 
\code{rcon$config}.}

\item{api_param}{\code{list} Additional API parameters to pass into the
body of the API call. This provides users to execute calls with options
that may not otherwise be supported by \code{redcapAPI}.}
}
\description{
Export the logging (audit trail) of all changes made to 
  a project, including data exports, data changes, project 
  metadata changes, modification of user rights, etc.
}
\examples{
\dontrun{
url <- "Enter your API URL here"
  token <- "Enter your API token here"
  
  rcon <- redcapConnection(url = url, 
                           token = token)
                    
  # Export all of the logging events       
  exportLogging(rcon)
  
  # Export all of the events for record '2'
  exportLogging(rcon, 
                record = "2")
                
  #Export all of the events where a record was deleted
  exportLoging(rcon, 
               logtype = "record_delete")
}
}
\author{
Benjamin Nutter
}
