% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/importMappings.R
\name{importMappings}
\alias{importMappings}
\alias{importMappings.redcapApiConnection}
\title{Import Instrument Event Mapping}
\usage{
importMappings(rcon, data, refresh = TRUE, ...)

\method{importMappings}{redcapApiConnection}(
  rcon,
  data,
  refresh = TRUE,
  ...,
  error_handling = getOption("redcap_error_handling"),
  config = list(),
  api_param = list()
)
}
\arguments{
\item{rcon}{a \code{redcapConnection} object.}

\item{data}{\code{data.frame} with columns \code{arm_num}, 
\code{unique_event_name}, and \code{form}. See Details}

\item{refresh}{\code{logical(1)}. When \code{TRUE}, cached mappings 
in the \code{rcon} object are refreshed after the import.}

\item{...}{Additional arguments to pass to other methods.}

\item{error_handling}{An option for how to handle errors returned by the API.
see \code{\link{redcap_error}}}

\item{config}{\code{list} Additional configuration parameters to pass to 
\code{\link[httr]{POST}}. These are appended to any parameters in 
\code{rcon$config}.}

\item{api_param}{\code{list} Additional API parameters to pass into the
body of the API call. This provides users to execute calls with options
that may not otherwise be supported by \code{redcapAPI}.}
}
\description{
This method allows you to import Instrument-Event Mappings 
  into a project (this corresponds to the 'Designate Instruments for 
  My Events' page in the project).

NOTE: This only works for longitudinal projects.
}
\details{
The \code{arm_num} variable will be compared against existing arms
  in the project (via \code{rcon$arms()}. An error is returned if any of 
  the arm numbers are not found in the project.
  
The \code{unique_event_name} must exist in \code{rcon$events()}. An error
is returned if an value in the data doesn't match. 

The values of \code{form} must all match a form name in 
\code{rcon$instruments()}. An error is returned if any values provided 
do not match.
}
