% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exportDags.R
\name{exportDags}
\alias{exportDags}
\alias{exportDags.redcapApiConnection}
\title{Export Data Access Groups}
\usage{
exportDags(rcon, ...)

\method{exportDags}{redcapApiConnection}(
  rcon,
  ...,
  error_handling = getOption("redcap_error_handling"),
  config = list(),
  api_param = list()
)
}
\arguments{
\item{rcon}{\code{redcapConnection} object}

\item{...}{Additional arguments to pass to other methods.}

\item{error_handling}{An option for how to handle errors returned by the API.
see \code{\link{redcap_error}}}

\item{config}{\code{list} Additional configuration parameters to pass to 
\code{\link[httr]{POST}}. These are appended to any parameters in 
\code{rcon$config}.}

\item{api_param}{\code{list} Additional API parameters to pass into the
body of the API call. This provides users to execute calls with options
that may not otherwise be supported by \code{redcapAPI}.}
}
\description{
Export the Data Access Groups (DAGs) associated with a project.
  Returns a listing of the data access group, the unique name, and the
  integer ID number.
}
