% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eqc_WeeklyCycle.R
\name{eqc_WeeklyCycle}
\alias{eqc_WeeklyCycle}
\title{Weekly cycle level of daily precipitation}
\usage{
eqc_WeeklyCycle(
  xts_obj,
  ths = list(lv0 = c(n_days = 0), lv1to2 = c(n_days = 2, percent = 10))
)
}
\arguments{
\item{xts_obj}{xts of a single time series}

\item{ths}{list. List of parameters to define in which level would be the daily precipitation.}
}
\description{
The function determine the level (0, 1 or 2) of the weekly cycle test
}
\details{
Weekly cycles are characterized by the occurrence of wet days that significantly differ between the days of the week. To compute the weekly cycles, first, for each day of the week, the probability of precipitation is calculated by dividing the total number of wet days by the total counts of values. Later, the number of wet days is tested by a two-sided binomial test (95 \% confidence level). Based on how many days were significant, it was defined:
Level 0: no atypical weekly cycle (similar probability between the days of the week).
Level 1: at least two days present an atypical probability (significant test).
Level 2: more than two days present an atypical probability (significant test) or one day presents an extremely different probability (more than 10\%).
Argument ths present the above default thresholds for the levels definition.
}
\examples{
\dontrun{
set.seed(123)

# creating fake daily precipitation data
dates_t <- seq(as.Date("1980-01-01"), as.Date("2015-12-31"), by = "day")
prec <- round(rnorm(length(dates_t), mean = 1.2, sd = 6), 1)
prec[prec<0] <- 0
xts_obj <- xts::xts(prec, dates_t)
names(xts_obj) <- "prec"

# Comparison with visual inspection
eqc_Plot(xts_obj)
eqc_WeeklyCycle(xts_obj)

# it also work if there is some empty data (but not if all is NA)
xts_obj["1990/2010"] <- NA
eqc_Plot(xts_obj)
eqc_WeeklyCycle(xts_obj)

}

}
\references{
Hunziker, S., Gubler, S., Calle, J., Moreno, I., Andrade, M., Velarde, F., ... & Brönnimann, S. (2017). Identifying, attributing, and overcoming common data quality issues of manned station observations. https://doi.org/10.1002/joc.5037

Huerta, A., Serrano-Notivoli, R., & Brönnimann, S. (2024). SC-PREC4SA: A serially complete daily precipitation dataset for South America. https://doi.org/10.31223/X57D8R
}
