% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distances.R
\name{redist.distances}
\alias{redist.distances}
\title{Compute Distance between Partitions}
\usage{
redist.distances(district_membership, measure = "Hamming", ncores = 1)
}
\arguments{
\item{district_membership}{A matrix with one row for each precinct and one 
column for each map. Required.}

\item{measure}{String vector indicating which distances to compute. Implemented 
currently are "Hamming", "Manhattan", and "Euclidean". Use all to return all implemented 
measures.}

\item{ncores}{Number of cores to use for parallel computing. Default is 1.}
}
\value{
list of matrices of distances with one for each distance measure selected
}
\description{
Compute Distance between Partitions
}
\examples{
\dontrun{
data("algdat.p10")
distances <- redist.distances(district_membership = algdat.p10$cdmat)
distances$Hamming[1:5,1:5]
}
}
