% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compactness.R
\name{comp_log_st}
\alias{comp_log_st}
\title{Calculate Log Spanning Tree Compactness}
\usage{
comp_log_st(plans, shp, counties = NULL, adj)
}
\arguments{
\item{plans}{redist_plans object or plans_matrix where each row indicates a district assignment and each column is a plan}

\item{shp}{redist_map object or tibble with sf geometry column}

\item{counties}{column name in shp containing counties}

\item{adj}{zero-indexed adjacency list. Not required if \code{redist_map} supplied to \code{shp}.}
}
\value{
numeric vector
}
\description{
Calculate Log Spanning Tree Compactness
}
\examples{
data(nh)
data(nh_m)
# For a single plan:
comp_log_st(plans = nh$r_2020, shp = nh, counties = county, adj = nh$adj)

# Or many plans:
comp_log_st(plans = nh_m[, 3:5], shp = nh, counties = county, adj = nh$adj)

}
\references{
Cory McCartan and Kosuke Imai. 2020.
Sequential Monte Carlo for Sampling Balanced and Compact Redistricting Plans.
}
\concept{compactness}
