% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/refset.R
\name{refset}
\alias{\%r\%}
\alias{`\%r\%`}
\alias{refset}
\title{Create a reference to a subset of an object}
\usage{
refset(x, data, ..., drop = TRUE, dyn.idx = TRUE, read.only = FALSE,
  eval.env = parent.frame(), assign.env = parent.frame())

x \%r\% data
}
\arguments{
\item{x}{name of the refset to create, as a bare name or character string}

\item{data}{the object to refer to}

\item{...}{indices to subset with}

\item{drop}{passed to \code{\link{Extract}}}

\item{dyn.idx}{update indices dynamically}

\item{read.only}{create a read-only refset which throws an error if assigned
to}

\item{eval.env}{environment in which \code{data} and indices will be evaluated}

\item{assign.env}{environment in which the variable named by \code{x} will be created}
}
\value{
\code{refset} returns \code{NULL}, but the \code{x} argument
will be assigned to
in the calling environment (or in \code{env}, if it is specified).
\code{x} will have an attribute \code{".refset."}.
}
\description{
Create a refset - a reference to a subset of an object.
When the object changes, the
contents of the refset change, and when the refset is changed, the object
is changed too.
}
\details{
There are two ways to call \code{refset}. The two-argument form, e.g.
\code{refset(myref, mydata[rows,"column"])}, creates a reference to the
subset of \code{mydata} passed in the second argument.

The three-or-more argument form acts like the \code{\link{subset}} function:
the indices in \code{...} are applied to \code{data}. If \code{data} is a
data.frame, then the indices are interpreted within it, so you can refer to
columns directly: \code{refset(myref, mydata, a>1 & b<a,)}. Bare column names
must be quoted, however.

Empty arguments in \code{...} are allowed and are treated as indexing
the whole dimension, just as in \code{\link{Extract}}.

By default, the indices in subset are updated dynamically.
For example, if you call \code{refset(myref, mydata, x >= 3,)} and then
set \code{mydata$x <- 3}, the number of rows in \code{myref} will probably
increase. To turn this behaviour off and make a reference to a "fixed"
subset of your object, use \code{dyn.idx=FALSE}.

\code{\%r\%} is an infix version of the two-argument form.
}
\examples{
dfr <- data.frame(a=1:4, b=1:4)
ss <- dfr[1:2,]
refset(rs, dfr[1:2,])
dfr$a <- 4:1
ss # 1:2
rs # 4:3

# same:
refset(rs, dfr, 1:2, )

# same:
rs \%r\% dfr[1:2,]

vec <- 1:10
refset(middle, vec[4:6])
vec[4:6] <- NA
middle
middle <- 4:6 + 100
vec

# dynamic versus static indices:
dfr <- data.frame(a=rnorm(100), b=rnorm(100))
refset(ss, dfr, a>1,)
refset(ss.static, dfr, a>1,, dyn.idx=FALSE)
nrow(ss) == nrow(ss.static)
dfr$a <- dfr$a + 2 * dfr$b


precious.data <- rnorm(100)
refset(big, precious.data, precious.data>1, read.only=TRUE)
big
\dontrun{
big <- big * 2 # throws an error
}

# Using refset with other functions:
# dynamically updated calculated column
dfr <- data.frame(a=rnorm(10), b=rnorm(10))
refset(rs, transform(dfr, x=a+2*b+rnorm(10)))
rs
rs # different

# Non-readonly refset with other functions. Works but gives a warning:
\dontrun{
vec <- 1:5
refset(ssv, names(vec), read.only=FALSE)
ssv <- LETTERS[1:5]
vec
}
}
\seealso{
Refsets are implemented using \code{makeActiveBinding}.
}

