% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_bathrooms.R
\name{rfg_all_restrooms}
\alias{rfg_all_restrooms}
\title{All refuge restrooms}
\usage{
rfg_all_restrooms(accessible = FALSE, unisex = FALSE, verbose = TRUE)
}
\arguments{
\item{accessible}{If \code{TRUE}, only returns restrooms that meet the
Americans with Disability Act standards for accessibility.
Defaults to \code{FALSE}.}

\item{unisex}{If \code{TRUE}, only returns unisex restrooms.
Defaults to \code{FALSE}.}

\item{verbose}{If \code{TRUE}, prints query progress.
Defaults to \code{TRUE}.}
}
\value{
A tibble with details on all listed bathrooms.
}
\description{
All listed refuge restrooms, ordered by date added or last updated, with
the most recent additions and updates at the top.
}
\examples{
\donttest{

a <- rfg_all_restrooms(accessible = TRUE, unisex = TRUE)

}

}
