% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search.R
\name{rfg_search}
\alias{rfg_search}
\title{Restroom record search}
\usage{
rfg_search(search, accessible = FALSE, unisex = FALSE, verbose = TRUE)
}
\arguments{
\item{search}{A string to search for. Note that the API does not accept
wildcard searchs, searches all fields in all available records, and only
returns exact (case-insensitive) matches.}

\item{accessible}{If \code{TRUE}, only returns restrooms that meet the
Americans with Disability Act standards for accessibility.
Defaults to \code{FALSE}.}

\item{unisex}{If \code{TRUE}, only returns unisex restrooms.
Defaults to \code{FALSE}.}

\item{verbose}{If \code{TRUE}, prints query progress.
Defaults to \code{TRUE}.}
}
\value{
A tibble with all bathrooms matching your search request
}
\description{
Restroom record search
}
\examples{
\donttest{

s <- rfg_search(search="toronto")

}
}
