% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rdf.R
\docType{data}
\name{asylum_decisions}
\alias{asylum_decisions}
\title{Asylum Decisions}
\format{
A tibble.
\describe{
\item{year}{The year (e.g. 2020).}
\item{coo_name}{Country of origin name.}
\item{coo}{Country of origin UNHCR code.}
\item{coo_iso}{Country of origin ISO code.}
\item{coa_name}{Country of asylum name.}
\item{coa}{Country of asylum UNHCR code.}
\item{coa_iso}{Country of asylum ISO code.}
\item{procedure_type}{The procedure type describes the authority with whom the asylum claim was lodged.
It can be one of: \code{G} – Government, \code{J} - Joint, \code{U} – UNHCR.}
\item{dec_level}{The decision level provides more detail of the stage of the procedure.
Common values are \code{NA} (New applications), \code{RA} (repeat/reopened applications) and
\code{AR} (administrative review).}
\item{dec_pc}{The data type describes whether the data provided reflects cases or persons.
The most common situation is for the data on asylum applications lodged to reflect persons,
but in certain situations (e.g USA), the data provided by governments is at the level of cases.
A case can contain information on one or more persons.}
\item{dec_recognized}{The number of asylum applicants recognised as refugees under UNHCR’s mandate.}
\item{dec_other}{The number of asylum applicants recognised as refugees under other forms of complementary protection.}
\item{dec_rejected}{The number of asylum applicants whose asylum claims have been rejected.}
\item{dec_closed}{The number of asylum applicants whose asylum claims have been otherwise closed.}
\item{dec_total}{The total number of asylum applicants for which a decision on their asylum claim
has been made in the given reference period.}
}
}
\source{
\href{https://www.unhcr.org/refugee-statistics/}{UNHCR Refugee Data Finder}.
}
\usage{
asylum_decisions
}
\description{
Decisions taken on asylum claims by year and countries of asylum and origin.
Asylum claims are applications for international protection and
decisions on asylum claims can be positive, negative or otherwise closed.
}
\details{
See the notes on the data structure in the
\href{https://www.unhcr.org/refugee-statistics/methodology/}{methodology pages} for more details.
}
\examples{
asylum_decisions
}
\keyword{datasets}
