% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/create.prep.func.R
\name{create.prep.func}
\alias{create.prep.func}
\title{Construct a function for preprocessing functional predictors}
\usage{
create.prep.func(X, argvals = seq(0, 1, length = ncol(X)),
  method = c("fpca.sc", "fpca.face", "fpca.ssvd", "bspline", "interpolate"),
  options = NULL)
}
\arguments{
\item{X}{an \code{N} by \code{J=ncol(argvals)} matrix of function evaluations
\eqn{X_i(t_{i1}),., X_i(t_{iJ}); i=1,.,N.} For FPCA-based processing methods, these functions are
used to define the eigen decomposition used to preprocess current and future data (for example, in
\code{\link{predict.pfr}})}

\item{argvals}{matrix (or vector) of indices of evaluations of \eqn{X_i(t)}; i.e. a matrix with
\emph{i}th row \eqn{(t_{i1},.,t_{iJ})}}

\item{method}{character string indicating the preprocessing method. Options
are \code{"fpca.sc"}, \code{"fpca.face"}, \code{"fpca.ssvd"}, \code{"bspline"},
and \code{"interpolate"}. The first three use the corresponding existing function;
\code{"bspline"} uses an (unpenalized) cubic bspline smoother with \code{nbasis} basis
functions; \code{"interpolate"} uses linear interpolation.}

\item{options}{list of options passed to the preprocessing method; as an example, options for \code{fpca.sc}
  include \code{pve}, \code{nbasis}, and \code{npc}.}
}
\value{
a function that returns the preprocessed functional predictors, with arguments
  \item{newX}{The functional predictors to process}
  \item{argvals.}{Indices of evaluation of \code{newX}}
  \item{options.}{Any options needed to preprocess the predictor functions}
}
\description{
Prior to using functions \code{X} as predictors in a scalar-on-function regression, it is often
necessary to presmooth curves to remove measurement error or interpolate to a common grid. This
function creates a function to do this preprocessing depending on the method specified.
}
\author{
Jeff Goldsmith \email{ajg2202@cumc.columbia.edu}
}
\seealso{
\code{\link{pfr}}, \code{\link{fpca.sc}}, \code{\link{fpca.face}}, \code{\link{fpca.ssvd}}
}

