% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/m_step_cd2.R
\name{Mstep_cd2}
\alias{Mstep_cd2}
\title{Maximization step using coordinate descent optimization.}
\usage{
Mstep_cd2(
  p,
  item_data,
  pred_data,
  mean_predictors,
  var_predictors,
  eout,
  item_type,
  pen_type,
  tau_current,
  pen,
  alpha,
  gamma,
  anchor,
  final_control,
  samp_size,
  num_responses,
  num_items,
  num_quad,
  num_predictors,
  num_tau,
  max_tau
)
}
\arguments{
\item{p}{List of parameters.}

\item{item_data}{Matrix or data frame of item responses.}

\item{pred_data}{Matrix or data frame of DIF and/or impact predictors.}

\item{mean_predictors}{Possibly different matrix of predictors for the mean
impact equation.}

\item{var_predictors}{Possibly different matrix of predictors for the
variance impact equation.}

\item{eout}{E step output, including matrix for item and impact equations,
in addition to theta values (possibly adaptive).}

\item{item_type}{Optional character value or vector indicating the type of
item to be modeled.}

\item{pen_type}{Character value indicating the penalty function to use.}

\item{tau_current}{A single numeric value of tau that exists within
\code{tau_vec}.}

\item{pen}{Current penalty index.}

\item{alpha}{Numeric value indicating the alpha parameter in the elastic net
penalty function.}

\item{gamma}{Numeric value indicating the gamma parameter in the MCP
function.}

\item{anchor}{Optional numeric value or vector indicating which item
response(s) are anchors (e.g., \code{anchor = 1}).}

\item{final_control}{Control parameters.}

\item{samp_size}{Sample size in data set.}

\item{num_responses}{Number of responses for each item.}

\item{num_items}{Number of items in data set.}

\item{num_quad}{Number of quadrature points used for approximating the
latent variable.}

\item{num_predictors}{Number of predictors.}

\item{num_tau}{Logical indicating whether the minimum tau value needs to be
identified during the regDIF procedure.}

\item{max_tau}{Logical indicating whether to output the maximum tau value
needed to remove all DIF from the model.}
}
\value{
a \code{"list"} of estimates obtained from the maximization step using coordinate
descent
}
\description{
Maximization step using coordinate descent optimization.
}
\keyword{internal}
