% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hypothesis.testing.R
\name{test_coef_equality}
\alias{test_coef_equality}
\title{testing equality of two coefficients (difference between coefficients of regressors), a Wald test
note: if v is not alternatively specified, use car::linearHypothesis(lm_model, "X1 = X2")}
\usage{
test_coef_equality(model, var1.name, var2.name, v = NULL)
}
\arguments{
\item{model}{the model object, such as a "lm" object}

\item{var1.name}{X1 name in model, a string}

\item{var2.name}{X2 name in model, a string}

\item{v}{a customized variance-covariance matrix

data(mtcars)
m1 <- lm(mpg ~ vs + carb + hp + wt + wt * hp , data = mtcars)
summary(m1)
test_coef_equality(model = m1, var1.name = "carb", var2.name = "hp")}
}
\description{
testing equality of two coefficients (difference between coefficients of regressors), a Wald test
note: if v is not alternatively specified, use car::linearHypothesis(lm_model, "X1 = X2")
}
