% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RE2C.R
\name{RE2C}
\alias{RE2C}
\title{Random effect meta-analysis for correlated test statistics}
\usage{
RE2C(beta, stders, cor = diag(1, length(beta)), twoStep = FALSE)
}
\arguments{
\item{beta}{regression coefficients from each analysis}

\item{stders}{standard errors corresponding to betas}

\item{cor}{correlation matrix between of test statistics.  Default considers uncorrelated test statistics}

\item{twoStep}{Apply two step version of RE2C that is designed to be applied only after the fixed effect model.}
}
\value{
Return values:
\itemize{
\item{\code{stat1}: }{statistic testing effect mean}
\item{\code{stat2}: }{statistic testing effect heterogeneity}
\item{\code{RE2Cp}: }{RE2 p-value accounting for correlelation between tests}
\item{\code{RE2Cp.twoStep}: }{two step RE2C test after fixed effect test.  Only evaluated if twoStep==TRUE}
\item{\code{QE}: }{test statistic for the test of (residual) heterogeneity}
\item{\code{QEp}: }{p-value for the test of (residual) heterogeneity}
\item{\code{Isq}: }I^2 statistic
}
\code{QE}, \code{QEp} and \code{ISq} are only evaluted if correlation is diagonal
}
\description{
Random effect meta-analysis for correlated test statistics using RE2C
}
\details{
Perform random effect meta-analysis for correlated test statistics using RE2 method of Han and Eskin (2011), or RE2 for correlated test statistics from Han, et al., (2016).  Also uses RE2C method of Lee, Eskin and Han (2017) to further test for heterogenity in effect size. By default, correlation is set to identity matrix to for independent test statistics.

This method requires the correlation matrix to be symmatric positive definite (SPD).  If this condition is not satisfied, results will be NA.  If the matrix is not SPD, there is likely an issue with how it was generated. 

However, evaluating the correlation between observations that are not pairwise complete can give correlation matricies that are not SPD.  In this case, consider running \code{Matrix::nearPD( x, corr=TRUE)} to produce the nearest SPD matrix to the input.
}
\examples{
# Generate effects
library(mvtnorm)
library(clusterGeneration )

set.seed(1)
n = 4
Sigma = cov2cor(genPositiveDefMat(n)$Sigma)
beta = t(rmvnorm(1, rep(0, n), Sigma))
stders = rep(.1, n)

# Run fixed effects meta-analysis, 
# assume identity correlation  
LS( beta, stders)

# Run random effects meta-analysis,
# assume identity correlation  
RE2C( beta, stders)

# Run fixed effects meta-analysis, 
# account for correlation 
LS( beta, stders, Sigma)

# Run random effects meta-analysis,
# account for correlation 
RE2C( beta, stders, Sigma)

}
\references{
{
  \insertRef{lee2017increasing}{remaCor}

  \insertRef{han2016general}{remaCor}

  \insertRef{han2011random}{remaCor}
}
}
