% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download.R
\name{download}
\alias{download}
\title{Download a file}
\usage{
download(path, url, auth_token = NULL, basic_auth = NULL,
  quiet = TRUE, headers = NULL)
}
\arguments{
\item{path}{Path to download to. \code{dirname(path)} must exist.}

\item{url}{URL.}

\item{auth_token}{Token for token-based authentication or \code{NULL}.}

\item{basic_auth}{List with \code{user} and \code{password} for basic HTTP
authentication, or \code{NULL}.}

\item{quiet}{Passed to \code{\link[=download.file]{download.file()}} or \code{\link[curl:curl_download]{curl::curl_download()}}.}

\item{headers}{Named character vector of HTTP headers to use.}
}
\value{
\code{path}, if the download was successful.
}
\description{
Uses either the curl package for R versions older than 3.2.0,
otherwise a wrapper around \code{\link[=download.file]{download.file()}}.
}
\details{
We respect the \code{download.file.method} setting of the user. If it is
not set, then see \code{download_method()} for choosing a method.

Authentication can be supplied three ways:
\itemize{
\item By setting \code{auth_token}. This will append an HTTP \code{Authorization}
header: \code{Authorization: token {auth_token}}.
\item By setting \code{basic_auth} to a list with elements \code{user} and \code{password}.
This will append a proper \code{Authorization: Basic {encoded_password}}
HTTP header.
\item By specifying the proper \code{headers} directly.
}

If both \code{auth_token} and \code{basic_auth} are specified, that's an error.
\code{auth_token} and \code{basic_auth} are \emph{appended} to \code{headers}, so they
take precedence over an \code{Authorization} header that is specified
directly in \code{headers}.
}
\keyword{internal}
