% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_outliers.R
\name{plot_outliers}
\alias{plot_outliers}
\title{Visually check outliers (dot plot)}
\usage{
plot_outliers(
  data,
  group = NULL,
  response,
  method = "mad",
  criteria = 3,
  colours,
  xlabels = NULL,
  ytitle = NULL,
  xtitle = NULL,
  has.ylabels = TRUE,
  has.xlabels = TRUE,
  ymin,
  ymax,
  yby = 1,
  ...
)
}
\arguments{
\item{data}{The data frame.}

\item{group}{The group by which to plot the variable.}

\item{response}{The dependent variable to be plotted.}

\item{method}{Method to identify outliers, either (e.g., 3)
median absolute deviations ("mad", default) or standard deviations ("sd").}

\item{criteria}{How many MADs (or standard deviations) to use as
threshold (default is 3).}

\item{colours}{Desired colours for the plot, if desired.}

\item{xlabels}{The individual group labels on the x-axis.}

\item{ytitle}{An optional y-axis label, if desired.}

\item{xtitle}{An optional x-axis label, if desired.}

\item{has.ylabels}{Logical, whether the x-axis should have labels or not.}

\item{has.xlabels}{Logical, whether the y-axis should have labels or not.}

\item{ymin}{The minimum score on the y-axis scale.}

\item{ymax}{The maximum score on the y-axis scale.}

\item{yby}{How much to increase on each "tick" on the y-axis scale.}

\item{...}{Other arguments passed to \link[ggplot2:geom_dotplot]{ggplot2::geom_dotplot}.}
}
\value{
A dot plot of class ggplot, by group.
}
\description{
Easily and visually check outliers through a dot plot
with accompanying reference lines at +/- 3 MAD or SD. When providing
a group, data are group-mean centered and standardized (based on
MAD or SD); if no group is provided, data are simply standardized.
}
\examples{
# Make the basic plot
plot_outliers(
  airquality,
  group = "Month",
  response = "Ozone")

plot_outliers(
  airquality,
  response = "Ozone",
  method = "sd")

}
\seealso{
Other functions useful in assumption testing:
Tutorial:
\url{https://rempsyc.remi-theriault.com/articles/assumptions}
}
\keyword{dotplot}
\keyword{plots}
