% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nice_contrasts.R
\name{nice_contrasts}
\alias{nice_contrasts}
\title{Easy planned contrasts}
\usage{
nice_contrasts(
  response,
  group,
  covariates = NULL,
  data,
  effect.type = "cohens.d",
  bootstraps = 2000,
  ...
)
}
\arguments{
\item{response}{The dependent variable.}

\item{group}{The group for the comparison.}

\item{covariates}{The desired covariates in the model.}

\item{data}{The data frame.}

\item{effect.type}{What effect size type to use. One of "cohens.d" (default),
"akp.robust.d", "unstandardized", "hedges.g", "cohens.d.sigma", or "r".}

\item{bootstraps}{The number of bootstraps to use for the confidence interval}

\item{...}{Arguments passed to \link[bootES:bootES]{bootES::bootES}.}
}
\value{
A dataframe, with the selected dependent variable(s), comparisons of
interest, degrees of freedom, t-values, p-values, Cohen's d, and the
lower and upper 95\% confidence intervals of the
effect size (i.e., dR).
}
\description{
Easily compute planned contrast analyses (pairwise
comparisons similar to t-tests but more powerful when more than
2 groups), and format in publication-ready format. In this particular
case, the confidence intervals are bootstraped on chosen effect size
(default to Cohen's d).
}
\details{
Statistical power is lower with the standard \emph{t} test
compared than it is with the planned contrast version for two
reasons: a) the sample size is smaller with the \emph{t} test,
because only the cases in the two groups are selected; and b)
in the planned contrast the error term is smaller than it is
with the standard \emph{t} test because it is based on all the cases
(\href{https://web.pdx.edu/~newsomj/uvclass/ho_planned\%20contrasts.pdf}{source}).

The effect size and confidence interval are calculated via
\link[bootES:bootES]{bootES::bootES}, and correct for contrasts but not for covariates and
other predictors. Because this method uses bootstrapping, it is recommended
to set a seed before using for reproducibility reasons (e.g.,
\code{sed.seet(100)}).

Does not for the moment support nested comparisons for marginal means,
only a comparison of all groups. For nested comparisons, please use
\code{\link[emmeans:contrast]{emmeans::contrast()}} directly, or for the \emph{easystats} equivalent,
\code{\link[modelbased:estimate_contrasts]{modelbased::estimate_contrasts()}}.

When using \code{nice_lm_contrasts()}, please use \code{as.factor()} outside the
\code{lm()} formula, or it will lead to an error.
}
\examples{
\dontshow{if (requireNamespace("bootES", quietly = TRUE) && requireNamespace("modelbased", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Basic example
set.seed(100)
nice_contrasts(
  data = mtcars,
  response = "mpg",
  group = "cyl",
  bootstraps = 200
)
\donttest{
set.seed(100)
nice_contrasts(
  data = mtcars,
  response = "disp",
  group = "gear"
)

# Multiple dependent variables
set.seed(100)
nice_contrasts(
  data = mtcars,
  response = c("mpg", "disp", "hp"),
  group = "cyl"
)

# Adding covariates
set.seed(100)
nice_contrasts(
  data = mtcars,
  response = "mpg",
  group = "cyl",
  covariates = c("disp", "hp")
)

# Now supports more than 3 levels
mtcars2 <- mtcars
mtcars2$carb <- as.factor(mtcars2$carb)
set.seed(100)
nice_contrasts(
  data = mtcars,
  response = "mpg",
  group = "carb",
  bootstraps = 200
)

}
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link{nice_lm_contrasts}},
Tutorial: \url{https://rempsyc.remi-theriault.com/articles/contrasts}
}
\keyword{comparisons}
\keyword{contrasts}
\keyword{differences}
\keyword{group}
\keyword{pairwise}
\keyword{planned}
