% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/data.frame.R
\name{as.ejObject.data.frame}
\alias{as.ejObject.data.frame}
\title{Convert a dataframe to an ejObject}
\usage{
\method{as.ejObject}{data.frame}(x, recordID = NA, recordAttributes,
  eventDefinitions, metadata = list(), ...)
}
\arguments{
\item{x}{The dataframe to convert}

\item{recordID}{an ID for the record, if NA one is created}

\item{recordAttributes}{A character vector containing the names of the
columns in the dataframe that are attributes of the record}

\item{eventDefinitions}{A list of event definitions}

\item{metadata}{A list of metadata ejAttribute objects describing the dataset}

\item{...}{other parameters (to maintain consistency with the generic)}
}
\description{
Convert a dataframe to an ejObject
}
\note{
We assume one row per record.
}
\examples{
#Here we use the toyll (toy line-list) data provided inside the package
data(toyll)
toyll
#Here we some data clean-up (make the date columns POSIX objects)
#Date-time conversion could be made automatic but introduces
#a big risk of mis-conversion so we leave this to the user
#to ensure that we don't silently corrupt their data

toyll$date.of.onset <- as.POSIXct(toyll$date.of.onset)
toyll$date.of.admission <- as.POSIXct(toyll$date.of.admission)
toyll$date.of.discharge <- as.POSIXct(toyll$date.of.discharge)
toyll$contact1.date <- as.POSIXct(toyll$contact1.date)
toyll$contact2.date <- as.POSIXct(toyll$contact2.date)
toyll$contact3.date <- as.POSIXct(toyll$contact3.date)

ind.fields <- c(names(toyll)[1:5], "hospital", "fever", "sleepy")
x <- as.ejObject(toyll,
                 recordAttributes=ind.fields,
                 eventDefinitions=list(
                 define_ejEvent(name="admission", date="date.of.admission"),
                 define_ejEvent(name="discharge", date="date.of.discharge"),
                 define_ejEvent(name="contact1", date="contact1.date", attributes="contact1.id"),
                 define_ejEvent(name="contact2", date="contact2.date", attributes="contact2.id"),
                 define_ejEvent(name="contact3", date="contact3.date", attributes="contact3.id")
                 ))
print(x)
}

