% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{replyr_summary}
\alias{replyr_summary}
\title{Compute usable summary of columns of tbl.}
\usage{
replyr_summary(x, ..., countUniqueNum = FALSE, countUniqueNonNum = FALSE,
  cols = NULL)
}
\arguments{
\item{x}{tbl or item that can be coerced into such.}

\item{...}{force additional arguments to be bound by name.}

\item{countUniqueNum}{logical, if true include unique non-NA counts for numeric cols.}

\item{countUniqueNonNum}{logical, if true include unique non-NA counts for non-numeric cols.}

\item{cols}{if not NULL set of columns to restrict to.}
}
\value{
summary of columns.
}
\description{
Compute per-column summaries and return as a \code{data.frame}.
}
\details{
Can be slow compared to \code{dplyr::summarize_all()} (but serves a different purpose).
Also, for numeric columns includes \code{NaN} in \code{nna} count (as is typcial for \code{R}, e.g.,
\code{is.na(NaN)}).  And note: \code{replyr_summary()} currently skips "raw" columns.
}
\examples{

d <- data.frame(p= c(TRUE, FALSE, NA),
                r= I(list(1,2,3)),
                s= NA,
                t= as.raw(3:5),
                w= 1:3,
                x= c(NA,2,3),
                y= factor(c(3,5,NA)),
                z= c('a',NA,'z'),
                stringsAsFactors=FALSE)
d$q <- list(1,2,3)
replyr_summary(d)

}
