\name{source_data}
\alias{source_data}
\title{Load plain-text data from a URL (either http or https)}
\source{
  Based on source_url from the Hadley Wickham's devtools
  package.
}
\usage{
  source_data(url, sha1 = NULL, sep = ",", header = TRUE)
}
\arguments{
  \item{url}{The plain-text formatted data's URL.}

  \item{sha1}{Character string of the file's SHA-1 hash,
  generated by \code{source_data}. Note if you are using
  data stored using Git, this is not the file's commit
  SHA-1 hash.}

  \item{sep}{The separator method for the data. For
  example, to load comma-separated values data (CSV) use
  \code{sep = ","} (the default). To load tab-separated
  values data (TSV) use \code{sep = "\t"}.}

  \item{header}{Logical, whether or not the first line of
  the file is the header (i.e. variable names). The default
  is \code{header = TRUE}.}
}
\value{
  a data frame
}
\description{
  \code{source_data} loads plain-text formatted data stored
  at a URL (both http and https) into R.
}
\details{
  Loads plain-text data (e.g. CSV, TSV) data from a URL.
  Works with both HTTP and HTTPS sites. Note: the URL you
  give for the \code{url} argument must be for the RAW
  version of the file. The function should work to download
  plain-text data from any secure URL (https), though I
  have not verified this.

  From the source_url documentation: "If a SHA-1 hash is
  specified with the sha1 argument, then this function will
  check the SHA-1 hash of the downloaded file to make sure
  it matches the expected value, and throw an error if it
  does not match. If the SHA-1 hash is not specified, it
  will print a message displaying the hash of the
  downloaded file. The purpose of this is to improve
  security when running remotely-hosted code; if you have a
  hash of the file, you can be sure that it has not
  changed."
}
\examples{
# Download electoral disproportionality data stored on GitHub
# Note: Using shortened URL created by bitly
DisData <- source_data("http://bit.ly/Ss6zDO")

# Check to see if SHA-1 hash matches downloaded file
DisDataHash <- source_data("http://bit.ly/Ss6zDO", sha1 = "195637339e8483dd634fae38e16ad8f24a403aef")
}
\seealso{
  \link{httr} and \code{\link{read.table}}
}

