% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/repoS3.R
\name{repo_rm}
\alias{repo_rm}
\title{Remove item from the repo (and the disk).}
\usage{
repo_rm(repo, name = NULL, tags = NULL)
}
\arguments{
\item{repo}{An object of class repo.}

\item{name}{An item's name.}

\item{tags}{A list of tags: all items matching the list will be
removed.}
}
\value{
Used for side effects.
}
\description{
Remove item from the repo (and the disk).
}
\examples{
repo_path <- file.path(tempdir(), "example_repo")
repo <- repo_open(repo_path, TRUE)
repo$put(1, "item1", "Sample item 1", "info", replace=TRUE)
repo$put(2, "item2", "Sample item 2", "info", replace=TRUE)
print(repo)
repo$rm("item1")
print(repo)

## wiping temporary repo
unlink(repo_path, TRUE)
}

