% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/repoS3.R
\name{repo_tag}
\alias{repo_tag}
\title{Add tags to an item.}
\usage{
repo_tag(repo, name = NULL, newtags, tags = NULL)
}
\arguments{
\item{repo}{An object of class repo.}

\item{name}{An item name.}

\item{newtags}{A list of tags that will be added to the item's tag
list.}

\item{tags}{A list of tags: newtags will be added to all items
matching the list.}
}
\value{
Used for side effects.
}
\description{
Add tags to an item.
}
\examples{
repo_path <- file.path(tempdir(), "example_repo")
repo <- repo_open(repo_path, TRUE)
repo$put(1, "item1", "Sample item 1", "tag1", replace=TRUE)
repo$print(show="t")
repo$tag("item1", "tag2")
repo$print(show="t")

## wiping temporary repo
unlink(repo_path, TRUE)
}

