% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/repo_public.R
\name{repo_stash}
\alias{repo_stash}
\title{Quickly store temporary data}
\usage{
repo_stash(object, rename = deparse(substitute(object)))
}
\arguments{
\item{object}{The object to store in the repo.}

\item{rename}{An optional character containing the new name for the
item. Otherwise the name of object is used as item's name.}
}
\value{
Used for side effects.
}
\description{
A very simplified call to put that only requires to specify
a variable name.
}
\details{
The \code{name} parameter is used to search the parent (or a
    different specified) environment for the actual object to
    store. Then it is also used as the item name. The reserved tags
    "stash" and "hide" are set. In case a stashed item by the same
    name already exists, it is automatically overwritten. In case a
    non-stashed item by the same name already exists, an error is
    raised. A different name can be specified through the rename
    parameter in such cases.
}
\examples{
\dontrun{
rp_path <- file.path(tempdir(), "example_repo")
rp <- repo_open(rp_path, TRUE)
tempdata <- runif(10)
rp$stash(tempdata)
rp$info("tempdata")

## wiping temporary repo
unlink(rp_path, TRUE)
}
}
\seealso{
repo_put, repo_lazydo
}
