% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report.lm.R, R/report.lme4.R
\name{report.lm}
\alias{report.lm}
\alias{report_effectsize.lm}
\alias{report_table.lm}
\alias{report_statistics.lm}
\alias{report_parameters.lm}
\alias{report_intercept.lm}
\alias{report_model.lm}
\alias{report_performance.lm}
\alias{report_info.lm}
\alias{report_text.lm}
\alias{report_random.merMod}
\title{Reporting (General) Linear Models}
\usage{
\method{report}{lm}(x, include_effectsize = TRUE, effectsize_method = "refit", ...)

\method{report_effectsize}{lm}(x, effectsize_method = "refit", ...)

\method{report_table}{lm}(x, include_effectsize = TRUE, ...)

\method{report_statistics}{lm}(
  x,
  table = NULL,
  include_effectsize = TRUE,
  include_diagnostic = TRUE,
  ...
)

\method{report_parameters}{lm}(
  x,
  table = NULL,
  include_effectsize = TRUE,
  include_intercept = TRUE,
  ...
)

\method{report_intercept}{lm}(x, table = NULL, ...)

\method{report_model}{lm}(x, table = NULL, ...)

\method{report_performance}{lm}(x, table = NULL, ...)

\method{report_info}{lm}(
  x,
  effectsize = NULL,
  include_effectsize = FALSE,
  parameters = NULL,
  ...
)

\method{report_text}{lm}(x, table = NULL, ...)

\method{report_random}{merMod}(x, ...)
}
\arguments{
\item{x}{Object of class \code{lm} or \code{glm}.}

\item{include_effectsize}{If \code{FALSE}, won't include effect-size related
indices (standardized coefficients, etc.).}

\item{effectsize_method}{See documentation for
\code{\link[effectsize:effectsize]{effectsize::effectsize()}}.}

\item{...}{Arguments passed to or from other methods.}

\item{table}{Provide the output of  \code{report_table()} to avoid its
re-computation.}

\item{include_diagnostic}{If \code{FALSE}, won't include diagnostic related
indices for Bayesian models (ESS, Rhat).}

\item{include_intercept}{If \code{FALSE}, won't include the intercept.}

\item{effectsize}{Provide the output of \code{report_effectsize()} to avoid
its re-computation.}

\item{parameters}{Provide the output of \code{report_parameters()} to avoid
its re-computation.}
}
\value{
An object of class \code{\link[=report]{report()}}.
}
\description{
Create reports for (general) linear models.
}
\examples{
\donttest{
library(report)

# Linear models
model <- lm(Sepal.Length ~ Petal.Length * Species, data = iris)
r <- report(model)
r
summary(r)
as.data.frame(r)
summary(as.data.frame(r))

# Logistic models
model <- glm(vs ~ disp, data = mtcars, family = "binomial")
r <- report(model)
r
summary(r)
as.data.frame(r)
summary(as.data.frame(r))
}

\dontshow{if (requireNamespace("lme4", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
# Mixed models
library(lme4)
model <- lme4::lmer(Sepal.Length ~ Petal.Length + (1 | Species), data = iris)
r <- report(model)
r
summary(r)
as.data.frame(r)
summary(as.data.frame(r))
}
\dontshow{\}) # examplesIf}
}
\seealso{
Specific components of reports (especially for stats models):
\itemize{
\item \code{\link[=report_table]{report_table()}}
\item \code{\link[=report_parameters]{report_parameters()}}
\item \code{\link[=report_statistics]{report_statistics()}}
\item \code{\link[=report_effectsize]{report_effectsize()}}
\item \code{\link[=report_model]{report_model()}}
\item \code{\link[=report_priors]{report_priors()}}
\item \code{\link[=report_random]{report_random()}}
\item \code{\link[=report_performance]{report_performance()}}
\item \code{\link[=report_info]{report_info()}}
\item \code{\link[=report_text]{report_text()}}
}

Other types of reports:
\itemize{
\item \code{\link[=report_system]{report_system()}}
\item \code{\link[=report_packages]{report_packages()}}
\item \code{\link[=report_participants]{report_participants()}}
\item \code{\link[=report_sample]{report_sample()}}
\item \code{\link[=report_date]{report_date()}}
}

Methods:
\itemize{
\item \code{\link[=as.report]{as.report()}}
}

Template file for supporting new models:
\itemize{
\item \code{\link[=report.default]{report.default()}}
}
}
