% Generated by roxygen2 (4.0.2): do not edit by hand
\name{calculate_metrics}
\alias{calculate_metrics}
\title{Calculate and summarize loss of load probability metrics}
\usage{
calculate_metrics(time.data, outage.table, raw = FALSE, ...)
}
\arguments{
\item{time.data}{Time series data formatted with \code{\link{format_timedata}}
(must have a \code{NetLoad} column, see details)}

\item{outage.table}{Outage table used in the lookup, created with \code{\link{outage_table}}}

\item{raw}{Return summary metrics (\code{FALSE}, default) or raw hourly output (\code{TRUE})}

\item{...}{Additional parameters passed to \code{\link{sliding_window}}}
}
\description{
Given a time data object, summarize probabilities into metrics. The function automatically
applies these calculation for each scenario, level of aggregation and area.
}
\details{
The time data object must have a column called \code{NetLoad} (see the examples for an easy
method to generate it).

Summary metrics include daily loss-of-load expectation (\code{LOLE}), loss-of-load
hours (\code{LOLH}), maximum LOLP (\code{PeakLOLP}) and expected unserved energy
(\code{EUE}).
}
\examples{
# Create outage table with 200 5-MW units
gens <- data.frame(Capacity = rep(5, 200),
                   EFOR = rep(0.08, 200))
out.table <- outage_table(gens)

# Create random load and wind data and format
tdata <- data.frame(Time = 1:8760,
                    Load = runif(8760, 450, 850),
                    Wind = runif(8760, 0, 100))
td <- format_timedata(tdata)

# Get metrics for net load (load - wind)
td2 <- td
td2$NetLoad <- td2$Load - td2$Wind
calculate_metrics(td2, out.table)

# Get metrics for just load
td3 <- td
td3$NetLoad <- td3$Load - td3$Wind
calculate_metrics(td3, out.table)

# Get raw data (i.e., not summarized)
calculate_metrics(td2, out.table, raw = TRUE)
}
\seealso{
\code{\link{format_timedata}} and \code{\link{outage_table}} to create \code{time.data}
         and \code{outage.table} objects, respectively

\code{\link{sliding_window}} is used internally to extend \code{time.data}

\code{\link{calculate_elcc}} uses this function to calculate ELCC
}

