% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NPSimulation.R
\name{MetaAnalysisSimulations}
\alias{MetaAnalysisSimulations}
\title{MetaAnalysisSimulations}
\usage{
MetaAnalysisSimulations(
  mean = 0,
  sd = 1,
  diff = 0.5,
  GroupSize = 10,
  type = "n",
  Replications = 50,
  Exp = 5,
  seed = 456,
  alpha = 0.05,
  FourGroup = FALSE,
  StdAdj = 0,
  BlockEffect = 0,
  BlockStdAdj = 0,
  StdExp = 0,
  MAMethod = "PM",
  returnES = F
)
}
\arguments{
\item{mean}{the value used for the mean of control group in the simulated data. It can be any real number including zero.}

\item{sd}{the value used for the spread of the control group and the spread of the treatment group in the simulated data. The value must be a real value greater than 0.}

\item{diff}{mean+diff is the value used for the mean of the treatment group. It can be zero.}

\item{GroupSize}{is the size of each of the groups comprising one experiment. GroupSize should be an integer of 4 or more}

\item{type}{specifies the distribution being simulated. The permited values are "n" for the normal distribution,  "l" for the lognormal distribution, "g" for the gamma distribution and "lap" for the Laplace distribution. The parameter defaults to "n".}

\item{Replications}{The number of times the set of experiments is simulated. It defaults to 500.}

\item{Exp}{the number of experiments being simulated. Exp should be an integer of 2 or more. It defaults to 5.}

\item{seed}{specifies the seed to be used to initiate the simulation, so the simulation is repeatable. It defaults to 456.}

\item{alpha}{This is the Type 1 probability level used in significnace tests. It defaults to 0.05.}

\item{FourGroup}{is a Boolean variable that determines whether the experiment is a two group experiments or a 4-Group randomised block experiment. It defaults to FALSE which means a two group experiment is the default condition.}

\item{StdAdj}{specifies the adjustment made to the treatment variance if it is required to simulate variance heterogeneity due to the treatment. It defaults to 0.}

\item{BlockEffect}{specified a fixed block effect that can be applied to randomized blocks designs.}

\item{BlockStdAdj}{specifies the adjustment made to the variance of one block if it is required to simulate heterogeneity due to  blocks in a randomized blocks experiment. The variance adjusment is made to the same block that any Block affect is applied to. It defaults to 0.}

\item{StdExp}{specifies the adjustment made to the variance of each experiment  if it is required to simulate variance heterogeneity due to individual experiments in a family. It defaults to 0.}

\item{MAMethod}{specifies the model to be used when experimental effect sizes ar aggregated using the R metafor package.}

\item{returnES}{if TRUE the function outputs the summary statistics otherwise it outputs the meta-analysis results for each family. The parameter defaults to FALSE}
}
\value{
The parameter either returns the meta-analysis values obtained from each family or the average values of the meta-analysis over all replications.
}
\description{
This function simulates data from many families of experiments. The number of families simulated is defined by the Replications parameter. The parameter Exp determines the number of experiments in each family. The function simulates data from one of four distributions and uses the data to construct two of groups of equal size (GroupSize). The experimental design of individual experiments in each family is determined by the FourGroup parameter. If FourGroup=FALSE, the basic experimental design is a balanced two group randomized experiment, otherwise the experimental design is a balanced four group experiment corresponding to a randomized blocks experiment. The function calls either NP2GroupMetaAnalysisSimulation or NP4GroupMetaAnalysisSimulation to generate and analyse data for each individual family. The function either returns the meta-analysed data from each experiment or provides summary statistics.
}
\examples{
MetaAnalysisSimulations(mean=0,sd=1,diff=0.5,GroupSize=10,type="n",Replications=25,Exp=5,
seed=456,alpha=0.05,FourGroup=FALSE,StdAdj=0,BlockEffect=0,BlockStdAdj=0,StdExp=0,MAMethod="PM")
# A tibble: 1 x 26
# Averagektau Averagektauctvar AveragetauSigCVt AverageCliffd AverageCliffdvar AverageCliffdsig
# <dbl>            <dbl>            <dbl>         <dbl>            <dbl>            <dbl>
#  1       0.164          0.00375             0.72         0.311           0.0134             0.72
#… with 20 more variables: Averagephat <dbl>, Averagephatvar <dbl>, Averagephatsig <dbl>,
#  MAAverage <dbl>, MAVariance <dbl>, MASignificant <dbl>, HetSignificant <dbl>, PMAAverage <dbl>,
#  PMASignificant <dbl>, PMAHetSignificant <dbl>, Mean.phat <dbl>, phat.sig <dbl>, Mean.d <dbl>,
#  d.sig <dbl>, Mean.g.exact <dbl>, g.exact.sig <dbl>, Mean.g.approx <dbl>, g.approx.sig <dbl>,
#  Mean.Cohend <dbl>, Cohend.sig <dbl>
MetaAnalysisSimulations(mean=0,sd=1,diff=0.734,GroupSize=100,type="l",Replications=25,Exp=5,
seed=456,alpha=0.05,FourGroup=FALSE,StdAdj=0,BlockEffect=0,BlockStdAdj=0,StdExp=0,MAMethod="PM")
#  A tibble: 1 x 26
#  Averagektau Averagektauctvar AveragetauSigCVt AverageCliffd AverageCliffdvar AverageCliffdsig
# <dbl>            <dbl>            <dbl>         <dbl>            <dbl>            <dbl>
#  0.200         0.000276                1         0.399          0.00109                1
# … with 20 more variables: Averagephat <dbl>, Averagephatvar <dbl>, Averagephatsig <dbl>,
#   MAAverage <dbl>, MAVariance <dbl>, MASignificant <dbl>, HetSignificant <dbl>, PMAAverage <dbl>,
#   PMASignificant <dbl>, PMAHetSignificant <dbl>, Mean.phat <dbl>, phat.sig <dbl>, Mean.d <dbl>,
#   d.sig <dbl>, Mean.g.exact <dbl>, g.exact.sig <dbl>, Mean.g.approx <dbl>, g.approx.sig <dbl>,
#   Mean.Cohend <dbl>, Cohend.sig <dbl>
# MetaAnalysisSimulations(mean=0,sd=1,diff=0.5,GroupSize=10,type="n",Replications=10,Exp=5,
# seed=456,alpha=0.05,FourGroup=TRUE,StdAdj=0,BlockEffect=0.5,BlockStdAdj=0,StdExp=0,
# MAMethod="PM",returnES=TRUE)
# A tibble: 10 x 31
# Family NumExp GroupSize AveKtau AveKtauctvar tauSigCVt AveCliffd AveCliffdvar AveCliffdsig
# <int>  <dbl>     <dbl>   <dbl>        <dbl> <lgl>         <dbl>        <dbl> <lgl>
#  1      1      5        10   0.133      0.00206 TRUE          0.252      0.00742 TRUE
# 2      2      5        10   0.161      0.00190 TRUE          0.306      0.00681 TRUE
# 3      3      5        10   0.135      0.00206 TRUE          0.256      0.00744 TRUE
# 4      4      5        10   0.16       0.00191 TRUE          0.304      0.00686 TRUE
# 5      5      5        10   0.133      0.00178 TRUE          0.252      0.00636 TRUE
# 6      6      5        10   0.192      0.00178 TRUE          0.364      0.00634 TRUE
# 7      7      5        10   0.189      0.00185 TRUE          0.36       0.00661 TRUE
# 8      8      5        10   0.126      0.00199 TRUE          0.24       0.00715 TRUE
# 9      9      5        10   0.132      0.00200 TRUE          0.25       0.00719 TRUE
# 10     10      5        10   0.18       0.00181 TRUE          0.342      0.00646 TRUE
# # … with 22 more variables: Avephat <dbl>, Avephatvar <dbl>, Avephatsig <lgl>, MAMean <dbl>,
# #   MAvar <dbl>, MASig <lgl>, QE <dbl>, QEp <dbl>, HetSig <lgl>, P.mean <dbl>, P.rsig <lgl>,
# #   P.hetsig <lgl>, Mean.phat <dbl>, phat.sig <lgl>, Mean.d <dbl>, d.sig <lgl>,
# #   Mean.g.exact <dbl>, g.exact.sig <lgl>, Mean.g.approx <dbl>, g.approx.sig <lgl>,
# #   Cohend.mean <dbl>, Cohend.sig <lgl>
}
\author{
Barbara Kitchenham and Lech Madeyski
}
