% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paths.R
\name{normPath}
\alias{normPath}
\alias{normPath,character-method}
\alias{normPath,list-method}
\alias{normPath,NULL-method}
\alias{normPath,missing-method}
\alias{normPath,logical-method}
\alias{normPathRel}
\title{Normalize file paths}
\usage{
normPath(path)

\S4method{normPath}{character}(path)

\S4method{normPath}{list}(path)

\S4method{normPath}{NULL}(path)

\S4method{normPath}{missing}()

\S4method{normPath}{logical}(path)

normPathRel(path)
}
\arguments{
\item{path}{A character vector of filepaths.}
}
\value{
Character vector of cleaned up filepaths.
}
\description{
Checks the specified path for formatting consistencies:
\enumerate{
\item use slash instead of backslash;
\item do tilde etc. expansion;
\item remove trailing slash.
}
}
\details{
Additionally, \code{normPath()} attempts to create a absolute paths,
whereas \code{normPathRel()} maintains relative paths.

\if{html}{\out{<div class="sourceCode">}}\preformatted{d> getwd()
[1] "/home/achubaty/Documents/GitHub/PredictiveEcology/reproducible"
d> normPathRel("potato/chips")
[1] "potato/chips"
d> normPath("potato/chips")
[1] "/home/achubaty/Documents/GitHub/PredictiveEcology/reproducible/potato/chips"
}\if{html}{\out{</div>}}
}
\examples{
## normalize file paths
paths <- list("./aaa/zzz",
              "./aaa/zzz/",
              ".//aaa//zzz",
              ".//aaa//zzz/",
              ".\\\\\\\\aaa\\\\\\\\zzz",
              ".\\\\\\\\aaa\\\\\\\\zzz\\\\\\\\",
              file.path(".", "aaa", "zzz"))

checked <- normPath(paths)
length(unique(checked)) ## 1; all of the above are equivalent

## check to see if a path exists
tmpdir <- file.path(tempdir(), "example_checkPath")

dir.exists(tmpdir) ## FALSE
tryCatch(checkPath(tmpdir, create = FALSE), error = function(e) FALSE) ## FALSE

checkPath(tmpdir, create = TRUE)
dir.exists(tmpdir) ## TRUE

unlink(tmpdir, recursive = TRUE)
}
