% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/cache_delete.R
\name{cache_delete}
\alias{cache_delete}
\alias{cache_delete_all}
\title{Delete cached files}
\usage{
cache_delete(x, cache_path = "~/.rerddap", force = FALSE)

cache_delete_all(cache_path = "~/.rerddap", force = FALSE)
}
\arguments{
\item{x}{File names}

\item{cache_path}{path to cached files}

\item{force}{(logical) Should files be force deleted? Default: \code{FALSE}}
}
\description{
Delete cached files
}
\examples{
\dontrun{
# delete files by name in cache
# cache_delete(files = '9911750294a039b8b517c8bf288978ea.csv')
# cache_delete(files = c('9911750294a039b8b517c8bf288978ea.csv',
#                  'b26825b6737da13d6a52c28c8dfe690f.csv'))

# You can delete from the output of griddap or tabledap fxns
## tabledap
(table_res <- tabledap('erdCalCOFIfshsiz'))
cache_delete(table_res)

## griddap
(grid_res <- griddap('noaa_esrl_027d_0fb5_5d38',
 time = c('2012-01-01','2012-06-12'),
 latitude = c(21, 18),
 longitude = c(-80, -75)
))
cache_delete(grid_res)
}
}
\author{
Scott Chamberlain <myrmecocystus@gmail.com>
}
\references{
\url{http://upwell.pfeg.noaa.gov/erddap/index.html}
}
\seealso{
\code{\link{cache_list}}, \code{\link{cache_details}}
}

