% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RunFeatureImportance.R
\name{RunFeatureImportanceBinary}
\alias{RunFeatureImportanceBinary}
\title{Compute Feature Importance of a single RerF tree}
\usage{
RunFeatureImportanceBinary(tree, unique.projections)
}
\arguments{
\item{tree}{a single tree from a trained RerF model with argument store.impurity = TRUE.}

\item{unique.projections}{a list of all of the unique split projections used in the RerF model.}
}
\value{
feature.imp
}
\description{
Computes feature importance of every unique feature used to make a split in a single tree.
}
\examples{
library(rerf)
X <- iris[, -5]
Y <- iris[[5]]
store.impurity <- TRUE
FUN <- RandMatBinary
forest <- RerF(X, Y, FUN = FUN, num.cores = 1L, store.impurity = store.impurity)
FeatureImportance(forest, num.cores = 1L)
}
