# This file was generated by Rcpp::compileAttributes
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' @title A fast distance algorithm for two matrices written in C++ 
#' @description Computes distances between two data matrices using "euclid", "cor", "cosine" 
#' @usage 
#' fastDist(X,Y,method)
#' @param X a \code{matrix}
#' @param Y a \code{matrix}
#' @param method a \code{string} with possible values "euclid", "cor", "cosine"
#' @return a distance \code{matrix}
#' @keywords internal
#' @useDynLib resemble
#' @author Antoine Stevens and Leonardo Ramirez-Lopez
fastDist <- function(X, Y, method) {
    .Call('resemble_fastDist', PACKAGE = 'resemble', X, Y, method)
}

#' @title A fast (parallel for linux) algorithm of (squared) Euclidean cross-distance for vectors written in C++ 
#' @description A fast (parallel for linux) algorithm of (squared) Euclidean cross-distance for vectors written in C++ 
#' @usage 
#' fastDistVV(X, cores)
#' @param X a \code{vector}
#' @return a \code{vector} of distance (lower triangle of the distance matrix, stored by column)
#' @details used internally in orthoProjection
#' @author Antoine Stevens
#' @keywords internal 
#' @useDynLib resemble
fastDistVV <- function(X, cores) {
    .Call('resemble_fastDistVV', PACKAGE = 'resemble', X, cores)
}

#' @title A fast (serial) algorithm of (squared) Euclidean cross-distance for vectors written in C++ 
#' @description A fast (parallel for linux) algorithm of (squared) Euclidean cross-distance for vectors written in C++ 
#' @usage 
#' fastDistVVL(X)
#' @param X a \code{vector}
#' @return a \code{vector} of distance (lower triangle of the distance matrix, stored by column)
#' @details used internally in orthoProjection
#' @author Leo Ramirez-Lopez
#' @keywords internal 
#' @useDynLib resemble
#' 
fastDistVVL <- function(X) {
    .Call('resemble_fastDistVVL', PACKAGE = 'resemble', X)
}

#' @title A function to compute indices of minimum values of a distance vector
#' @description For internal use only
#' @usage 
#' minDissV(X,cores)
#' @param X a \code{vector} of distance (as computed in \code{resemble:::fastDistVV} or \code{base::dist})
#' @param cores number of cores used to run the computation
#' @return a \code{vector} of the indices of the nearest neighbours
#' @details 
#' Used internally to find the nearest neighbours. 
#' It searches in lower (or upper?) trianguular matrix. Therefore this must be the format of the 
#' input data. The piece of code int \code{len = (sqrt(X.size()*8+1)+1)/2} generated an error in CRAN
#' since \code{sqrt} cannot be applied to integers.
#' @keywords internal
#' @useDynLib resemble
#' @author Antoine Stevens 
minDissV <- function(X, cores) {
    .Call('resemble_minDissV', PACKAGE = 'resemble', X, cores)
}

#' @title Moving/rolling correlation distance of two matrices
#' @description Computes a moving window correlation distance between two data matrices
#' @usage 
#' movcorDist(X,Y,w)
#' @param X a \code{matrix}
#' @param Y a \code{matrix}
#' @param w window size (must be odd)
#' @return a \code{matrix} of correlation distance
#' @keywords internal
#' @useDynLib resemble
#' @author Leonardo Ramirez-Lopez and Antoine Stevens
movcorDist <- function(X, Y, w) {
    .Call('resemble_movcorDist', PACKAGE = 'resemble', X, Y, w)
}

#' @title Function for identifiying the column in a \code{matrix} with the largest standard deviation
#' @description Identifies the column with the largest standard deviation. For internal use only!
#' @usage wcolSds(X)
#' @param X a \code{matrix}.
#' @return a value indicating the index of the column with the largest standard deviation. 
#' @useDynLib resemble
#' @author Leonardo Ramirez-Lopez
#' @keywords internal 
#' @useDynLib resemble
wcolSds <- function(X) {
    .Call('resemble_wcolSds', PACKAGE = 'resemble', X)
}

#' @title Function for computing the standard deviation of each column in a \code{matrix}
#' @description Computes the standard deviation of each column in a \code{matrix}. For internal use only!
#' @usage colSds(X)
#' @param X a a \code{matrix}.
#' @return a vector of standard deviation values. 
#' @useDynLib resemble
#' @author Leonardo Ramirez-Lopez
#' @keywords internal 
#' @useDynLib resemble
colSds <- function(X) {
    .Call('resemble_colSds', PACKAGE = 'resemble', X)
}

#' @title Function for computing the mean of each column in a \code{matrix}
#' @description Computes the mean of each column in a \code{matrix}. For internal use only!
#' @usage colSds(X)
#' @param X a a \code{matrix}.
#' @return a vector of mean values. 
#' @useDynLib resemble
#' @author Leonardo Ramirez-Lopez
#' @keywords internal 
#' @useDynLib resemble
cms <- function(X) {
    .Call('resemble_cms', PACKAGE = 'resemble', X)
}

#' @title orthogonal scores algorithn of partial leat squares (opls)
#' @description Computes orthogonal socres partial least squares (opls) regressions with the NIPALS algorithm. It allows multiple response variables. 
#' For internal use only!
#' @usage 
#' opls(X, Y, ncomp, scale, 
#'      maxiter, tol, 
#'      regression = TRUE, 
#'      pcSelmethod = "cumvar", 
#'      pcSelvalue = 0.99)
#' @param X a \code{matrix} of predictor variables.
#' @param Y a \code{matrix} of either a single or multiple response variables.
#' @param ncomp the number of pls components.
#' @param scale logical indicating whether \code{X} must be scaled.
#' @param maxiter maximum number of iterations.
#' @param tol limit for convergence of the algorithm in the nipals algorithm.
#' @param regression a logical indicating if the function is being used for regression. Otherwise it is used only for projection. Default is \code{TRUE}.
#' @param pcSelmethod if \code{regression = TRUE}, the method for selecting the number of components. 
#' Options are: \code{'cumvar'} (for selecting the number of principal components based on a given 
#' cumulative amount of explained variance) and \code{"var"} (for selecting the number of principal 
#' components based on a given amount of explained variance). Default is \code{'cumvar'}
#' @param pcSelvalue a numerical value that complements the selected method (\code{pcSelmethod}). 
#' If \code{"cumvar"} is chosen, it must be a value (higher than 0 and lower than 1) indicating the maximum 
#' amount of cumulative variance that the retained components should explain. If \code{"var"} is chosen, 
#' it must be a value (higher than 0 and lower than 1) indicating that components that explain (individually) 
#' a variance lower than this threshold must be excluded. If \code{"manual"} is chosen, it must be a value 
#' specifying the desired number of principal components to retain. Default is 0.99.
#' @return a list containing the following elements:
#' \itemize{
#' \item{\code{coefficients}}{ the \code{matrix} of regression coefficients.}
#' \item{\code{bo}}{ a \code{matrix} of one row containing the intercepts for each component.}
#' \item{\code{scores}}{ the \code{matrix} of scores.}
#' \item{\code{X.loadings}}{ the \code{matrix} of X loadings.}
#' \item{\code{Y.loadings}}{ the \code{matrix} of Y loadings.}
#' \item{\code{projectionM}}{ the projection \code{matrix}.}
#' \item{\code{variance}}{ a \code{list} conating two objects: \code{x.var} and \code{y.var}. 
#' These objects contain information on the explained variance for the \code{X} and \code{Y} matrices respectively.}
#' \item{\code{transf}}{ a \code{list} conating two objects: \code{Xcenter} and \code{Xscale}}. 
#' } 
#' @useDynLib resemble
#' @author Leonardo Ramirez-Lopez
#' @keywords internal 
#' @useDynLib resemble
opls <- function(X, Y, ncomp, scale, maxiter, tol, regression = TRUE, pcSelmethod = "cumvar", pcSelvalue = 0.99) {
    .Call('resemble_opls', PACKAGE = 'resemble', X, Y, ncomp, scale, maxiter, tol, regression, pcSelmethod, pcSelvalue)
}

#' @title fast orthogonal scores algorithn of partial leat squares (opls)
#' @description Computes orthogonal socres partial least squares (opls) regressions with the NIPALS algorithm. It allows multiple response variables. 
#' In contrast to code{opls} function, this one does not compute unnecessary data for local regressions.
#' For internal use only!
#' @usage 
#' fopls(X, Y, ncomp, scale, 
#'       maxiter, tol)
#' @param X a \code{matrix} of predictor variables.
#' @param Y a \code{matrix} of either a single or multiple response variables.
#' @param ncomp the number of pls components.
#' @param scale logical indicating whether \code{X} must be scaled.
#' @param maxiter maximum number of iterations.
#' @param tol limit for convergence of the algorithm in the nipals algorithm.
#' @return a list containing the following elements:
#' \itemize{
#' \item{\code{coefficients}}{ the \code{matrix} of regression coefficients.}
#' \item{\code{bo}}{ a \code{matrix} of one row containing the intercepts for each component.}
#' \item{\code{transf}}{ a \code{list} conating two objects: \code{Xcenter} and \code{Xscale}}. 
#' } 
#' @useDynLib resemble
#' @author Leonardo Ramirez-Lopez
#' @keywords internal 
#' @useDynLib resemble
fopls <- function(X, Y, ncomp, scale, maxiter, tol) {
    .Call('resemble_fopls', PACKAGE = 'resemble', X, Y, ncomp, scale, maxiter, tol)
}

#' @title Prediction function for the \code{opls} and \code{opls2} functions
#' @description Predicts response values based on a model generated by either by \code{opls} or the \code{opls2} functions. 
#' For internal use only!. 
#' @usage predopls(bo, b, ncomp, newdata, scale, Xscale)
#' @param bo a numeric value indicating the intercept.
#' @param b the \code{matrix} of regression coefficients.
#' @param ncomp an integer value indicating how may components must be used in the prediction.
#' @param newdata a \code{matrix} containing the predictor variables.
#' @param scale a logical indicating whether the matrix of predictors used to create the regression model was scaled.
#' @param Xscale if \code{scale = TRUE} a \code{matrix} of one row with the values that must be used for scaling \code{newdata}.
#' @return a \code{matrix} of predicted values.
#' @useDynLib resemble
#' @author Leonardo Ramirez-Lopez
#' @keywords internal 
#' @useDynLib resemble
predopls <- function(bo, b, ncomp, newdata, scale, Xscale) {
    .Call('resemble_predopls', PACKAGE = 'resemble', bo, b, ncomp, newdata, scale, Xscale)
}

#' @title Projection function for the \code{opls} function
#' @description Projects new spectra onto a PLS space based on a model generated by either by \code{opls} or the \code{opls2} functions. 
#' For internal use only!. 
#' @usage projectpls(projectionm, ncomp, newdata, scale, Xcenter, Xscale)
#' @param projectionm the projection \code{matrix} generated by the \code{opls} function.
#' @param ncomp an integer value indicating how may components must be used in the prediction.
#' @param newdata a \code{matrix} containing the predictor variables.
#' @param scale a logical indicating whether the matrix of predictors used to create the regression model was scaled.
#' @param Xscale if \code{scale = TRUE} a \code{matrix} of one row with the values that must be used for scaling \code{newdata}.
#' @param Xcenter a \code{matrix} of one row with the values that must be used for centering \code{newdata}.
#' @return a \code{matrix} corresponding to the new spectra projected onto the PLS space 
#' @useDynLib resemble
#' @author Leonardo Ramirez-Lopez
#' @keywords internal 
#' @useDynLib resemble
projectpls <- function(projectionm, ncomp, newdata, scale, Xcenter, Xscale) {
    .Call('resemble_projectpls', PACKAGE = 'resemble', projectionm, ncomp, newdata, scale, Xcenter, Xscale)
}

#' @title Internal Cpp function for computing the weights of the PLS components necessary for weighted average PLS
#' @description For internal use only!. 
#' @usage
#' waplswCpp(projectionm, 
#'           xloadings, 
#'           coefficients, 
#'           newX, 
#'           minF, 
#'           maxF, 
#'           scale, 
#'           Xcenter, 
#'           Xscale)
#' @param projectionm the projection \code{matrix} generated either by the \code{opls} function.
#' @param xloadings .
#' @param coefficients the \code{matrix} of regression coefficients.
#' @param newX a \code{matrix} of one new spectra to be predicted.
#' @param minF an integer indicating the minimum number of pls components.
#' @param maxF an integer indicating the maximum number of pls components.
#' @param scale a logical indicating whether the matrix of predictors used to create the regression model was scaled.
#' @param Xcenter a \code{matrix} of one row with the values that must be used for centering \code{newdata}.
#' @param Xscale if \code{scale = TRUE} a \code{matrix} of one row with the values that must be used for scaling \code{newdata}.
#' @return a \code{matrix} of one row with the weights for each component between the max. and min. specified. 
#' @useDynLib resemble
#' @author Leonardo Ramirez-Lopez
#' @keywords internal 
#' @useDynLib resemble
waplswCpp <- function(projectionm, xloadings, coefficients, newX, minF, maxF, scale, Xcenter, Xscale) {
    .Call('resemble_waplswCpp', PACKAGE = 'resemble', projectionm, xloadings, coefficients, newX, minF, maxF, scale, Xcenter, Xscale)
}

#' @title Internal Cpp function for performing leave-group-out cross validations for pls regression 
#' @description For internal use only!. 
#' @usage pplscv_cpp(X, Y, scale, method, 
#'                   mindices, pindices, 
#'                   minF, ncomp, 
#'                   newX, 
#'                   maxiter, tol, 
#'                   waplsgrid)
#' @param X a \code{matrix} of predictor variables.
#' @param Y a \code{matrix} of a single response variable.
#' @param scale a logical indicating whether the matrix of predictors (\code{X}) must be scaled.
#' @param method the method used for regression. One of the following options: \code{'pls'} or \code{'wapls1'} or \code{'completewapls1p'}.
#' @param mindices a \code{matrix} with \code{n} rows and \code{m} columns where \code{m} is equivalent to the number of 
#' resampling iterations. The elements of each column indicate the indices of the samples to be used for modeling at each 
#' iteration.
#' @param pindices a \code{matrix} with \code{k} rows and \code{m} columns where \code{m} is equivalent to the number of 
#' resampling iterations. The elements of each column indicate the indices of the samples to be used for predicting at each 
#' iteration.
#' @param minF an integer indicating the number of minimum pls components (if the \code{method = 'pls'}).
#' @param ncomp an integer indicating the number of pls components.
#' @param newX a \code{matrix} of one row corresponding to the sample to be predicted (if the \code{method = 'wapls1'}).
#' @param maxiter maximum number of iterations.
#' @param tol limit for convergence of the algorithm in the nipals algorithm.
#' @param waplsgrid the grid on which the search for the best combination of minimum and maximum pls factors of \code{'wapls1'} is based on in case \code{method = 'completewapls1p'}.
#' @return a list containing the following one-row matrices:
#' \itemize{
#' \item{\code{rmse.seg}}{ the RMSEs.}
#' \item{\code{st.rmse.seg}}{ the standardized RMSEs.}
#' \item{\code{rsq.seg}}{ the coefficients of determination.}
#' } 
#' @useDynLib resemble
#' @author Leonardo Ramirez-Lopez
#' @keywords internal 
#' @useDynLib resemble
pplscv_cpp <- function(X, Y, scale, method, mindices, pindices, minF, ncomp, newX, maxiter, tol, waplsgrid) {
    .Call('resemble_pplscv_cpp', PACKAGE = 'resemble', X, Y, scale, method, mindices, pindices, minF, ncomp, newX, maxiter, tol, waplsgrid)
}

#' @title Gaussian process regression with linear kernel (gprdp)
#' @description Carries out a gaussian process regression with a linear kernel (dot product). For internal use only!
#' @usage gprdp(X, Y, noisev, scale) 
#' @param X a matrix of predictor variables
#' @param Y a matrix with a single response variable
#' @param noisev a value indicating the variance of the noise for Gaussian process regression. Default is 0.001. a matrix with a single response variable
#' @param scale a logical indicating whether both the predictors 
#' and the response variable must be scaled to zero mean and unit variance.
#' @return a list containing the following elements:
#' \itemize{
#' \item{\code{Xz}}{ the (final transformed) \code{matrix} of predictor variables.}
#' \item{\code{alpha}}{ the alpha \code{matrix}.}
#' \item{\code{is.scaled}}{ logical indicating whether both the predictors and response variable were scaled to zero mean and unit variance.}
#' \item{\code{Xcenter}}{ if matrix of predictors was scaled, the centering vector used for \code{X}.}
#' \item{\code{Xscale}}{ if matrix of predictors was scaled, the scaling vector used for \code{X}.}
#' \item{\code{Ycenter}}{ if matrix of predictors was scaled, the centering vector used for \code{Y}.}
#' \item{\code{Yscale}}{ if matrix of predictors was scaled, the scaling vector used for \code{Y}.}
#' }
#' @useDynLib resemble
#' @author Leonardo Ramirez-Lopez
#' @keywords internal 
#' @useDynLib resemble
gprdp <- function(X, Y, noisev = 0.001, scale = TRUE) {
    .Call('resemble_gprdp', PACKAGE = 'resemble', X, Y, noisev, scale)
}

#' @title Prediction function for the \code{gprdp} function (Gaussian process regression with dot product covariance)
#' @description Predicts response values based on a model generated by the \code{gprdp} function (Gaussian process regression with dot product covariance). For internal use only!. 
#' @usage predgprdp(Xz, alpha, newdata, scale, Xcenter, Xscale, Ycenter, Yscale)
#' @param Xz the final (scaled?) matrix of predictors used to create the regression model in the \code{gprdp} function
#' @param alpha the alpha matrix corresponding to the regression model in the \code{gprdp} function
#' @param newdata a \code{matrix} containing the predictor variables
#' @param scale a logical indicating whether the matrix of predictors used to create the regression model 
#' (in the \code{gprdp} function) was scaled
#' @param Xcenter if \code{center = TRUE} a \code{matrix} of one row with the values that must be used for centering \code{newdata}.
#' @param Xscale if \code{scale = TRUE} a \code{matrix} of one row with the values that must be used for scaling \code{newdata}.
#' @param Ycenter if \code{center = TRUE} a \code{matrix} of one row with the values that must be used for accounting for the centering of the response variable.
#' @param Yscale if \code{scale = TRUE} a \code{matrix} of one row with the values that must be used  for accounting for the scaling of the response variable.
#' @return a \code{matrix} of predicted values
#' @useDynLib resemble
#' @author Leonardo Ramirez-Lopez
#' @keywords internal 
#' @useDynLib resemble
predgprdp <- function(Xz, alpha, newdata, scale, Xcenter, Xscale, Ycenter, Yscale) {
    .Call('resemble_predgprdp', PACKAGE = 'resemble', Xz, alpha, newdata, scale, Xcenter, Xscale, Ycenter, Yscale)
}

#' @title Internal Cpp function for performing leave-group-out cross validations for pls regression 
#' @description For internal use only!. 
#' @usage pgpcv_cpp(X, Y, mindices, pindices, noisev = 0.001, scale)
#' @param X a \code{matrix} of predictor variables.
#' @param Y a \code{matrix} of a single response variable.
#' @param mindices a \code{matrix} with \code{n} rows and \code{m} columns where \code{m} is equivalent to the number of 
#' resampling iterations. The elements of each column indicate the indices of the samples to be used for modeling at each 
#' iteration.
#' @param pindices a \code{matrix} with \code{k} rows and \code{m} columns where \code{m} is equivalent to the number of 
#' resampling iterations. The elements of each column indicate the indices of the samples to be used for predicting at each 
#' iteration.
#' @param mindices a \code{matrix} with \code{n} rows and \code{m} columns where \code{m} is equivalent to the number of 
#' resampling iterations. The elements of each column indicate the indices of the samples to be used for modeling at each 
#' iteration.
#' @param pindices a \code{matrix} with \code{k} rows and \code{m} columns where \code{m} is equivalent to the number of 
#' resampling iterations. The elements of each column indicate the indices of the samples to be used for predicting at each 
#' iteration.
#' @param ncomp an integer indicating the number of pls components.
#' @param scale a logical indicating whether both the predictors 
#' and the response variable must be scaled to zero mean and unit variance.
#' @return a list containing the following one-row matrices:
#' \itemize{
#' \item{\code{rmse.seg}}{ the RMSEs.}
#' \item{\code{st.rmse.seg}}{ the standardized RMSEs.}
#' \item{\code{rsq.seg}}{ the coefficients of determination.}
#' } 
#' @useDynLib resemble
#' @author Leonardo Ramirez-Lopez
#' @keywords internal 
#' @useDynLib resemble
pgpcv_cpp <- function(X, Y, mindices, pindices, noisev = 0.001, scale = TRUE) {
    .Call('resemble_pgpcv_cpp', PACKAGE = 'resemble', X, Y, mindices, pindices, noisev, scale)
}

#' @title A function to compute row-wise index of minimum values of a square distance matrix
#' @description For internal use only
#' @usage 
#' which_min(X,cores)
#' @param X a square \code{matrix} of distance
#' @param cores number of cores used to run the computation
#' @return a \code{vector} of the indices of the minimum value in each row of the input \code{matrix}
#' @details Used internally to find the nearest neighbours
#' @keywords internal
#' @useDynLib resemble
#' @author Antoine Stevens 
which_min <- function(X, cores) {
    .Call('resemble_which_min', PACKAGE = 'resemble', X, cores)
}

#' @title A function to compute indices of minimum values of a distance vector
#' @description For internal use only
#' @usage 
#' which_minV(X,cores)
#' @param X a \code{vector} of distance (as computed in \code{resemble:::fastDistVV} or \code{base::dist})
#' @param cores number of cores used to run the computation
#' @return a \code{vector} of the indices of the nearest neighbours
#' @details 
#' Used internally to find the nearest neighbours. 
#' It searches in lower (or upper?) trianguular matrix. Therefore this must be the format of the 
#' input data. The piece of code int \code{len = (sqrt(X.size()*8+1)+1)/2} generated an error in CRAN
#' since \code{sqrt} cannot be applied to integers.
#' @keywords internal
#' @useDynLib resemble
#' @author Antoine Stevens 
which_minV <- function(X, cores) {
    .Call('resemble_which_minV', PACKAGE = 'resemble', X, cores)
}

