% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/hurst_basic.R
\name{Hurst}
\alias{Hurst}
\title{Hurst coefficient estimation}
\usage{
Hurst(Q)
}
\arguments{
\item{Q}{vector or annualized time series object. Net inflows or streamflow totals.}
}
\value{
Returns an estimate of the Hurst coefficient, H (0.5 < H < 1).
}
\description{
Hurst coefficient estimation.
}
\examples{
Q_annual <- aggregate(ResX_inflow.ts) #convert monthly to annual data
Hurst(Q_annual)
}
\references{
H.E.Hurst (1951) Long-term storage capacity of reservoirs, Transactions of the American Society of Civil Engineers 116, 770-808.

Pfaff, B. (2008) Analysis of integrated and cointegrated time series with R, Springer, New York. [p.68]
}

