% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_erlang_mixture.R
\name{fit_erlang_mixture}
\alias{fit_erlang_mixture}
\title{Fit an Erlang mixture using an ECME-Algorithm}
\usage{
fit_erlang_mixture(
  dist,
  obs,
  start,
  min_iter = 0L,
  max_iter = 100L,
  skip_first_e = FALSE,
  tolerance = 1e-05,
  trace = FALSE,
  parallel = FALSE,
  ...
)
}
\arguments{
\item{dist}{An \code{ErlangMixtureDistribution}. It is assumed, that both \code{probs}
and \code{scale} are to be estimated.}

\item{obs}{Set of observations as produced by \code{\link[=trunc_obs]{trunc_obs()}} or convertible
via \code{\link[=as_trunc_obs]{as_trunc_obs()}}.}

\item{start}{Initial values of all placeholder parameters.
If missing, starting values are obtained from \code{\link[=fit_dist_start]{fit_dist_start()}}.}

\item{min_iter}{Minimum number of EM-Iterations}

\item{max_iter}{Maximum number of EM-Iterations (weight updates)}

\item{skip_first_e}{Skip the first E-Step (update Probability weights)?
This can help if the initial values cause a mixture component to vanish in
the first E-Step before the starting values can be improved.}

\item{tolerance}{Numerical tolerance.}

\item{trace}{Include tracing information in output?
If \code{TRUE}, additional tracing information will be added to the result list.}

\item{parallel}{Enable experimental parallel evaluation of expected log-likelihood?}

\item{...}{Passed to \code{\link[=fit_dist_start]{fit_dist_start()}} if \code{start} is missing.}
}
\value{
A list with elements
\itemize{
\item \code{params} the fitted parameters in the same structure as \code{init}.
\item \code{params_hist} (if \code{trace} is TRUE) the history of parameters
(after each e- and m- step). Otherwise an empty list.
\item \code{iter} the number of outer EM-iterations
\item \code{logLik} the final log-likelihood
}
}
\description{
Fit an Erlang mixture using an ECME-Algorithm
}
\examples{
dist <- dist_erlangmix(list(NULL, NULL, NULL))
params <- list(
  shapes = list(1L, 4L, 12L),
  scale = 2.0,
  probs = list(0.5, 0.3, 0.2)
)
x <- dist$sample(100L, with_params = params)
fit_erlang_mixture(dist, x, init = "kmeans")

}
\seealso{
Other distribution fitting functions: 
\code{\link{fit_blended}()},
\code{\link{fit_dist}()},
\code{\link{fit_mixture}()}
}
\concept{distribution fitting functions}
