# Stamp 
# Stamp is like reshape but the "stamping" function is passed the entire data frame, instead of just a few variables.
# 
# It is very similar to the \code{\link{by}} function except in the form
# of the output which is arranged using the formula as in \code{\link{reshape}}
# 
# Note that it's very easy to create objects that R can't print with this
# function.  You will probably want to save the results to a variable and
# then use extract the results.  See the examples.
# 
# @arguments data.frame (no molten)
# @arguments formula that describes arrangement of result, columns ~ rows, see \code{\link{reshape}} for more information
# @arguments aggregation function to use, should take a data frame as the first argument
# @arguments arguments passed to the aggregation function
# @arguments margins to compute (character vector, or \code{TRUE} for all margins), can contain \code{grand_row} or \code{grand_col} to inclue grand row or column margins respectively.
# @arguments logical vector by which to subset the data frame, evaluated in the context of the data frame so you can 
#@keyword manip 
#X french_fries$time <- as.numeric(as.character(french_fries$time))
#X stamp(french_fries, subject ~ ., function(df) coef(lm(painty ~ time, df))[2])
#X stamp(french_fries, subject ~ treatment, function(df) coef(lm(painty ~ time, df))[2])
#X models <- stamp(french_fries, subject ~ ., function(df) lm(painty ~ time, df))
#X dim(models)
#X anova(models[[3,1]])
stamp <- function(data, formula = . ~ ., fun.aggregate, ..., margins=NULL, subset=TRUE) {
	if (inherits(formula, "formula")) formula <- deparse(substitute(formula)) 
	cast(data, formula, fun.aggregate, ..., margins=margins, subset=subset, df=TRUE)
}

# Condense a data frame
# 
# @arguments data frame
# @arguments character vector of variables to condense over
# @arguments function to condense with
# @arguments arguments passed to condensing function
# @keyword manip 
condense.df <- function(data, variables, fun, ...) {
	if (length(variables) == 0 ) {
		df <- data.frame(results = 0)
		df$results <- list(fun(data, ...))
		return(df)
	}

	sorted <- sort.df(data, variables)
	duplicates <- duplicated(sorted[,variables, drop=FALSE])
	index <- cumsum(!duplicates)

	results <- by(sorted, index, fun, ...)

	cols <- sorted[!duplicates,variables, drop=FALSE]
	cols$results <- array(results)
	cols
}
