% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reslifefsr.R
\name{reslifefsr}
\alias{reslifefsr}
\title{Calculate Residual Life Values Using a flexsurvreg() Object}
\usage{
reslifefsr(obj, life, p = 0.5, type = "mean", newdata = data.frame())
}
\arguments{
\item{obj}{Name of a flexsurvreg() object from which data is extracted.}

\item{life}{Value at which the user wants to calculate residual life. Must be a scalar.}

\item{p}{percentile for percentile residual life, default is .5}

\item{type}{can be 'mean', 'median', 'percentile', or 'all'. Default is
'mean'.}

\item{newdata}{a data frame containing new data values to calculate residual
life for. Default is a blank data frame.}
}
\value{
A vector of residual life values
}
\description{
Calculate residual life values using a flexsurvreg() object. Contains an option to supply new data
and returns the output as a vector.
}
\examples{
library(flexsurv)
fitg <- flexsurv::flexsurvreg(formula = Surv(futime, fustat) ~ 1,
data = ovarian, dist="gengamma")
reslifefsr(obj = fitg, life = 6, p= .75, type= 'all')

fitg2 <- flexsurv::flexsurvreg(formula = Surv(futime, fustat) ~ age,
data = ovarian, dist="gengamma")
df_new = data.frame(age = 12)
reslifefsr(obj = fitg2, life = 3, type = 'median', newdata = df_new)

}
\references{
Jackson CH (2016). “flexsurv: a platform for parametric survival modeling in R.” Journal of
statistical software, 70.

Poynor V (2010). “Bayesian inference for mean residual life functions in survival analysis.”
Masters diss., University of California, Santa Cruz.

Prentice RL (1975). “Discrimination among some parametric models.” Biometrika, 62(3),
607–614.

Stacy EW (1962). “A generalization of the gamma distribution.” The Annals of mathematical
statistics, pp. 1187–1192
}
