% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/guess_TA.R
\encoding{UTF-8}
\name{guess_TA}
\alias{guess_TA}
\title{Estimate total alkalinity from salinity}
\usage{
guess_TA(temp = 25, sal = 35, region = NULL)
}
\arguments{
\item{temp}{temperature (°C). Default is 25 °C.}

\item{sal}{salinity (psu). Default is 35 psu. 31 \eqn{\le} \code{sal} \eqn{\le} 38; may be narrower for some regions.}

\item{region}{(optional) geographic region. Options are "(Sub)tropics", "Equatorial Upwelling Pacific", "North Atlantic", "North Pacific", and "Southern Ocean". Default is NULL. If undefined, the average from all these regions is used.}
}
\value{
An estimate of the total alkalinity (umol / kg). If \code{NA} or \code{NaN} are returned, confirm the \code{temp} and \code{sal} values are within acceptable ranges for the region of interest.
}
\description{
Estimate total alkalinity from salinity and temperature of surface seawater according to Lee et al. 2006. Useful when a rough guess of TA is needed because measuring TA is not possible or practical.
}
\details{
\describe{
	\item{(Sub)tropics}{\code{temp} \eqn{\ge} 20 and 31 \eqn{\le} \code{sal} \eqn{\le} 38}
	\item{Equatorial Upwelling Pacific}{\code{temp} \eqn{\ge} 18 and 31 \eqn{\le} \code{sal} \eqn{\le} 36.5}
	\item{North Atlantic}{0 \eqn{\le} \code{temp} \eqn{\le} 20 and 31 \eqn{\le} \code{sal} \eqn{\le} 37}
	\item{North Pacific}{\code{temp} \eqn{\le} 20 and 31 \eqn{\le} \code{sal} \eqn{\le} 35}
	\item{Southern Ocean}{\code{temp} \eqn{\le} 20 and 33 \eqn{\le} \code{sal} \eqn{\le} 36}
}
Estimates total alkalinity using the equations provided by Lee et al. 2006 (Geophysical Research Letters). While these equations are designed for open ocean environments, they can provide a rough estimate even for coastal environments. For improved estimate accuracy, the geographic region can be provided. The North Pacific region is longitude-dependent so a longitude of 150 °W is assumed which provides a typical value within the range. Only applicable for surface waters, not very accurate for the ocean interior.
}
\examples{
guess_TA(temp = 22, sal = 33)
guess_TA(temp = 12, sal = 33, region = "North Atlantic")
guess_TA(temp = 20, sal = 31:35)

}
\author{
Matthew A. Birk, \email{matthewabirk@gmail.com}
}
\references{
Lee K, Tong LT, Millero FJ, Sabine CL, Dickson AG, Goyet C, Park G-H, Wanninkhof R, Feely RA, Key RM. 2006. Global relationships of total alkalinity with salinity and temperature in surface waters of the world’s oceans. Geophys Res Lett. 33:L19605.
}
\seealso{
\code{\link{predict_pH}}
}

