% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_nh3.R
\encoding{UTF-8}
\name{predict_nh3}
\alias{predict_nh3}
\title{Predict NH3 / NH4+ concentration post-respiration}
\usage{
predict_nh3(
  o2_drop = 10,
  o2_unit = "percent_a.s.",
  o2_nh4_ratio,
  temp = 25,
  sal = 35,
  pH = 8.1,
  atm_pres = 1013.25
)
}
\arguments{
\item{o2_drop}{a numeric value or vector describing the change in O2. Default is 10.}

\item{o2_unit}{a string describing the unit used to measure \code{o2_drop}. Default is "percent_a.s." Options are from \code{\link{conv_o2}}.}

\item{o2_nh4_ratio}{molar ratio of O2 consumed to NH4+ produced.}

\item{temp}{temperature (°C). Default is 25 °C.}

\item{sal}{salinity (psu). Default is 35 psu.}

\item{pH}{seawater pH (total scale). Default is 8.1.}

\item{atm_pres}{atmospheric pressure (mbar). Default is 1013.25 mbar.}
}
\value{
A list containing the predicted NH3, NH4+, and TAN produced in mg/l.
}
\description{
Predicts the [NH3] and [NH4+] of seawater after a defined amount of oxygen consumption. Ammonotelic animals excrete the ionized form NH4+ (ammonium) but some of these ions dissociate into unionized NH3 (ammonia) which is toxic for most fishes and crustaceans around 0.4-2.0 mg/L (Boyd 2012).
}
\details{
Given a known amount of oxygen consumed and an estimated O2:N ratio, the amount of NH4 produced can be estimated. Production or consumption of ammonium by "background" microbes or conversion of ammonium to nitrite and nitrate is ignored since bacteria in the respirometer are typically sought to be in low levels. The amount of dissociation to produce ammonia is calculated by \code{\link[seacarb]{Kn}}.
}
\examples{
predict_nh3(o2_drop = 25, o2_nh4_ratio = 10)

}
\references{
Boyd C. 2012. Water Quality. In "Aquaculture: Farming Aquatic Animals and Plants". Blackwell Publishing, Ltd.
}
\seealso{
\code{\link{conv_o2}}, \code{\link{conv_nh4}}, \code{\link[seacarb]{Kn}}
}
\author{
Matthew A. Birk, \email{matthewabirk@gmail.com}
}
