/*
 * Decompiled with CFR 0.152.
 */
package org.restopt.choco;

import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.RealVar;
import org.chocosolver.solver.variables.UndirectedGraphVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;
import org.chocosolver.util.objects.setDataStructures.SetFactory;
import org.restopt.choco.LandscapeIndicesUtils;

public class PropSmallestEnclosingCircleSpatialGraph
extends Propagator<Variable> {
    private final UndirectedGraphVar g;
    private final double[][] coordinates;
    private final RealVar radius;
    private final RealVar centerX;
    private final RealVar centerY;
    private final ISet pointsSet;

    public PropSmallestEnclosingCircleSpatialGraph(UndirectedGraphVar g, double[][] coordinates, RealVar radius, RealVar centerX, RealVar centerY) {
        super(new Variable[]{g, radius, centerX, centerY}, (Priority)PropagatorPriority.LINEAR, false);
        this.g = g;
        this.coordinates = coordinates;
        this.radius = radius;
        this.centerX = centerX;
        this.centerY = centerY;
        this.pointsSet = SetFactory.makeBipartiteSet(0);
    }

    private ISet getKernelPoints() {
        return this.g.getMandatoryNodes();
    }

    private ISet getEnvelopePoints() {
        return this.g.getPotentialNodes();
    }

    private ISet getEnvelopeMinusKernelPoints() {
        ISet ker = this.getKernelPoints();
        ISet env = this.getEnvelopePoints();
        ISet envMinusKer = SetFactory.makeBipartiteSet(0);
        ISetIterator iSetIterator = env.iterator();
        while (iSetIterator.hasNext()) {
            int i = (Integer)iSetIterator.next();
            if (ker.contains(i)) continue;
            envMinusKer.add(i);
        }
        return envMinusKer;
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        ISet ker = this.getKernelPoints();
        ISet env = this.getEnvelopePoints();
        if (env.size() == 0) {
            if (this.radius.getLB() > 0.0) {
                this.fails();
            }
            return;
        }
        if (ker.size() == env.size()) {
            double[] minidisk = LandscapeIndicesUtils.minidisk(ker.toArray(), this.coordinates);
            double x = minidisk[0];
            double y = minidisk[1];
            double r = minidisk[2];
            if (x > this.centerX.getUB() + this.centerX.getPrecision() || x < this.centerX.getLB() - this.centerX.getPrecision() || y > this.centerY.getUB() + this.centerY.getPrecision() || y < this.centerY.getLB() - this.centerY.getPrecision() || r > this.radius.getUB() + this.radius.getPrecision() || r < this.radius.getLB() - this.radius.getPrecision()) {
                this.fails();
            }
            this.radius.updateBounds(minidisk[2], minidisk[2], this);
            this.centerX.updateBounds(minidisk[0], minidisk[0], this);
            this.centerY.updateBounds(minidisk[1], minidisk[1], this);
            return;
        }
        if (ker.size() > 0) {
            int[] kerArray = ker.toArray();
            double[] minidisk = LandscapeIndicesUtils.minidisk(kerArray, this.coordinates);
            double[] cker = new double[]{minidisk[0], minidisk[1]};
            double rker = minidisk[2];
            if (rker > this.radius.getUB() + this.radius.getPrecision()) {
                this.fails();
            }
            int[] envArray = env.toArray();
            double[] minidiskEnv = LandscapeIndicesUtils.minidisk(envArray, this.coordinates);
            double[] cEnv = new double[]{minidiskEnv[0], minidiskEnv[1]};
            double rEnv = minidiskEnv[2];
            if (rEnv < this.radius.getLB() - this.radius.getPrecision()) {
                this.fails();
            }
            int[] pointsArray = new int[ker.size() + 1];
            for (int i = 0; i < kerArray.length; ++i) {
                pointsArray[i] = kerArray[i];
            }
            ISetIterator iSetIterator = this.getEnvelopeMinusKernelPoints().iterator();
            while (iSetIterator.hasNext()) {
                int i = (Integer)iSetIterator.next();
                if (!(LandscapeIndicesUtils.distance(cker, this.coordinates[i]) > rker)) continue;
                pointsArray[pointsArray.length - 1] = i;
                double[] b_disk = LandscapeIndicesUtils.minidisk(pointsArray, this.coordinates);
                if (!(b_disk[2] > this.radius.getUB() + this.radius.getPrecision()) && !(b_disk[2] < this.radius.getLB() - this.radius.getPrecision())) continue;
                this.g.removeNode(i, this);
            }
        }
    }

    @Override
    public ESat isEntailed() {
        ISet ker = this.getKernelPoints();
        ISet env = this.getEnvelopePoints();
        if (env.size() == 0) {
            if (this.radius.getLB() > 0.0) {
                return ESat.FALSE;
            }
            return ESat.UNDEFINED;
        }
        if (ker.size() == env.size()) {
            double[] minidisk = LandscapeIndicesUtils.minidisk(ker.toArray(), this.coordinates);
            double x = minidisk[0];
            double y = minidisk[1];
            double r = minidisk[2];
            if (x > this.centerX.getUB() + this.centerX.getPrecision() || x < this.centerX.getLB() - this.centerX.getPrecision() || y > this.centerY.getUB() + this.centerY.getPrecision() || y < this.centerY.getLB() - this.centerY.getPrecision() || r > this.radius.getUB() + this.radius.getPrecision() || r < this.radius.getLB() - this.radius.getPrecision()) {
                return ESat.TRUE;
            }
            return ESat.TRUE;
        }
        double[] minidisk_LB = LandscapeIndicesUtils.minidisk(ker.toArray(), this.coordinates);
        double[] minidisk_UB = LandscapeIndicesUtils.minidisk(env.toArray(), this.coordinates);
        if (minidisk_UB.length > 0) {
            double x_ub = minidisk_UB[0];
            double y_ub = minidisk_UB[1];
            double r_ub = minidisk_UB[2];
            if (r_ub < this.radius.getLB() - this.radius.getPrecision() || x_ub < this.centerX.getLB() - this.centerX.getPrecision() || y_ub < this.centerY.getLB() - this.centerY.getPrecision()) {
                return ESat.FALSE;
            }
            if (minidisk_LB.length > 0) {
                double x_lb = minidisk_LB[0];
                double y_lb = minidisk_LB[1];
                double r_lb = minidisk_LB[2];
                if (r_lb > this.radius.getUB() + this.radius.getPrecision() || x_lb > this.centerX.getUB() + this.centerX.getPrecision() || y_lb > this.centerY.getUB() + this.centerY.getPrecision()) {
                    return ESat.FALSE;
                }
                return ESat.TRUE;
            }
        }
        return ESat.UNDEFINED;
    }
}

