/*
 * Decompiled with CFR 0.152.
 */
package org.restopt.objectives;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.chocosolver.solver.Solution;
import org.chocosolver.solver.constraints.Constraint;
import org.restopt.DataLoader;
import org.restopt.RestoptProblem;
import org.restopt.choco.LandscapeIndicesUtils;
import org.restopt.choco.PropEffectiveMeshSize;
import org.restopt.grid.regular.square.PartialRegularGroupedGrid;
import org.restopt.objectives.AbstractRestoptObjective;

public class EffectiveMeshSizeObjective
extends AbstractRestoptObjective {
    public static final String KEY_MESH_INITIAL = "mesh_initial";
    public static final String KEY_MESH = "mesh";
    public static final String KEY_MESH_BEST = "mesh_best";
    int precision;
    double initialValue;

    public EffectiveMeshSizeObjective(RestoptProblem problem, int timeLimit, boolean verbose, boolean maximize, int precision, String search) {
        super(problem, timeLimit, verbose, maximize, search);
        this.precision = precision;
    }

    public EffectiveMeshSizeObjective(RestoptProblem problem, int timeLimit, boolean verbose, boolean maximize, int precision) {
        this(problem, timeLimit, verbose, maximize, precision, "");
    }

    @Override
    public void initObjective() {
        DataLoader data = this.problem.getData();
        PartialRegularGroupedGrid grid = this.problem.getGrid();
        if (this.problem.getAdditionalVariables().containsKey(KEY_MESH)) {
            this.objective = this.problem.getAdditionalVariables().get(KEY_MESH);
        } else {
            this.objective = this.problem.getModel().intVar("MESH", 0, (int)((double)(data.getHeight() * data.getWidth() - grid.getDiscardSet().size()) * Math.pow(10.0, this.precision)));
            int landscapeArea = this.problem.getLandscapeArea();
            Constraint meshCons = new Constraint("MESH_constraint", new PropEffectiveMeshSize(this.problem.getHabitatGraphVar(), this.objective, grid.getSizeCells(), landscapeArea, this.precision, true));
            this.problem.getModel().post(meshCons);
            this.problem.getAdditionalVariables().put(KEY_MESH, this.objective);
        }
        this.initialValue = LandscapeIndicesUtils.effectiveMeshSize(this.problem.getHabitatGraph(), grid.getNbUngroupedCells() + this.problem.getNbLockedUpNonHabitatCells());
    }

    @Override
    public String getInitialValueMessage() {
        return "\nMESH initial = " + this.initialValue + "\n";
    }

    @Override
    public String[] getAdditionalKeys() {
        return new String[]{KEY_MESH_INITIAL, KEY_MESH, KEY_MESH_BEST};
    }

    @Override
    public Map<String, String> appendCharacteristics(Solution solution) {
        HashMap<String, String> charact = new HashMap<String, String>();
        charact.put(KEY_MESH_INITIAL, String.valueOf(1.0 * (double)Math.round(this.initialValue * Math.pow(10.0, this.precision)) / Math.pow(10.0, this.precision)));
        charact.put(KEY_MESH, String.valueOf(1.0 * (double)solution.getIntVal(this.objective) / Math.pow(10.0, this.precision)));
        charact.put(KEY_MESH_BEST, String.valueOf(1.0 * (double)this.getOptimalValue() / Math.pow(10.0, this.precision)));
        return charact;
    }

    @Override
    public List<String[]> appendMessages() {
        ArrayList<String[]> messages = new ArrayList<String[]>();
        messages.add(new String[]{KEY_MESH_INITIAL, "Initial MESH value: "});
        messages.add(new String[]{KEY_MESH, "MESH value: "});
        messages.add(new String[]{KEY_MESH_BEST, "Best known MESH value: "});
        return messages;
    }
}

