/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.variables.impl;

import org.chocosolver.solver.Cause;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.constraints.Constraint;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.IVariableMonitor;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.RealVar;
import org.chocosolver.solver.variables.SetVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IEventType;
import org.chocosolver.solver.variables.view.IView;
import org.chocosolver.util.iterators.EvtScheduler;

public abstract class AbstractVariable
implements Variable {
    static final String MSG_REMOVE = "remove last value";
    protected static final String MSG_EMPTY = "empty domain";
    protected static final String MSG_INST = "the variable is already instantiated to another value";
    static final String MSG_UNKNOWN = "unknown value";
    static final String MSG_UPP = "the new upper bound is lesser than the current lower bound";
    static final String MSG_LOW = "the new lower bound is greater than the current upper bound";
    static final String MSG_BOUND = "new bounds are incorrect";
    private final int ID;
    protected final Model model;
    protected final String name;
    protected Propagator<?>[] propagators;
    int[] pindices;
    private final int[] dindices;
    private final int dsize;
    private IView<?>[] views;
    private int[] idxInViews;
    private int vIdx;
    protected IVariableMonitor[] monitors;
    protected int mIdx;
    private final EvtScheduler<?> scheduler;
    private int instWI;
    private int mask;
    private ICause cause;
    public boolean scheduled;

    protected AbstractVariable(String name, Model model) {
        this.name = name;
        this.model = model;
        this.views = new IView[2];
        this.idxInViews = new int[2];
        this.monitors = new IVariableMonitor[2];
        this.propagators = new Propagator[8];
        this.pindices = new int[8];
        this.ID = this.model.nextId();
        this.model.associates(this);
        this.scheduler = this.createScheduler();
        this.dsize = this.scheduler.select(0) + 1;
        this.dindices = new int[this.dsize + 1];
        this.instWI = 0;
        this.scheduled = false;
    }

    protected abstract EvtScheduler<?> createScheduler();

    @Override
    public boolean isScheduled() {
        return this.scheduled;
    }

    @Override
    public void schedule() {
        this.scheduled = true;
    }

    @Override
    public void unschedule() {
        this.scheduled = false;
    }

    @Override
    public final int getId() {
        return this.ID;
    }

    @Override
    public final int link(Propagator<?> propagator, int idxInProp) {
        if (this.dindices[this.dsize] == this.propagators.length) {
            Propagator<?>[] tmp = this.propagators;
            this.propagators = new Propagator[tmp.length * 3 / 2 + 1];
            System.arraycopy(tmp, 0, this.propagators, 0, this.dindices[this.dsize]);
            int[] itmp = this.pindices;
            this.pindices = new int[itmp.length * 3 / 2 + 1];
            System.arraycopy(itmp, 0, this.pindices, 0, this.dindices[this.dsize]);
            if (this.pindices.length != this.propagators.length) {
                throw new UnsupportedOperationException("error: pindices.length != propagators.length in " + this);
            }
        }
        int pc = propagator.getPropagationConditions(idxInProp);
        return this.subscribe(propagator, idxInProp, this.scheduler.select(pc));
    }

    private void move(int from, int to) {
        if (this.propagators[from] != null) {
            this.propagators[to] = this.propagators[from];
            this.pindices[to] = this.pindices[from];
            this.propagators[to].setVIndices(this.pindices[from], to);
            this.propagators[from] = null;
        }
    }

    int subscribe(Propagator<?> p, int ip, int i) {
        for (int j = this.dsize - 1; j >= i; --j) {
            this.move(this.dindices[j], this.dindices[j + 1]);
            int n = j + 1;
            this.dindices[n] = this.dindices[n] + 1;
        }
        this.propagators[this.dindices[i]] = p;
        this.pindices[this.dindices[i]] = ip;
        return this.dindices[i];
    }

    @Override
    public int swapOnPassivate(Propagator<?> propagator, int idxInProp) {
        int pp = propagator.getVIndice(idxInProp);
        assert (pp != -1);
        int i = this.scheduler.select(propagator.getPropagationConditions(idxInProp));
        this.move(this.dindices[i + 1] - 1, pp);
        int j = i + 1;
        while (j < this.dsize) {
            this.move(this.dindices[j + 1] - 1, this.dindices[j] - 1);
            int n = j++;
            this.dindices[n] = this.dindices[n] - 1;
        }
        this.propagators[this.dindices[this.dsize] - 1] = propagator;
        this.pindices[this.dindices[this.dsize] - 1] = idxInProp;
        return this.dindices[this.dsize] - 1;
    }

    @Override
    public int swapOnActivate(Propagator<?> propagator, int idxInProp) {
        int pp = propagator.getVIndice(idxInProp);
        if (pp > -1) {
            assert (this.propagators[pp] == propagator);
            assert (this.dindices[this.dsize - 1] <= pp && pp <= this.dindices[this.dsize]);
            int i = this.scheduler.select(propagator.getPropagationConditions(idxInProp));
            int n = this.dsize;
            int n2 = this.dindices[n] - 1;
            this.dindices[n] = n2;
            this.move(n2, pp);
            for (int j = this.dsize - 1; j >= i; --j) {
                this.move(this.dindices[j], this.dindices[j + 1]);
                int n3 = j + 1;
                this.dindices[n3] = this.dindices[n3] + 1;
            }
            this.propagators[this.dindices[i]] = propagator;
            this.pindices[this.dindices[i]] = idxInProp;
            return this.dindices[i];
        }
        assert (propagator.getConstraint().getStatus() == Constraint.Status.FREE);
        return -1;
    }

    @Override
    public final void unlink(Propagator<?> propagator, int idxInProp) {
        int i = propagator.getVIndice(idxInProp);
        if (i > -1) {
            assert (this.propagators[i] == propagator) : "Try to unlink :\n" + propagator + "\nfrom " + this.getName() + " but found:\n" + this.propagators[i];
            int mask = 0;
            if (i < this.dindices[this.dsize - 1]) {
                mask = propagator.getPropagationConditions(this.pindices[i]);
            }
            this.cancel(i, this.scheduler.select(mask));
            propagator.setVIndices(idxInProp, -1);
        }
    }

    void cancel(int pp, int i) {
        this.move(this.dindices[i + 1] - 1, pp);
        int j = i + 1;
        while (j < this.dsize) {
            this.move(this.dindices[j + 1] - 1, this.dindices[j] - 1);
            int n = j++;
            this.dindices[n] = this.dindices[n] - 1;
        }
        int n = this.dsize;
        this.dindices[n] = this.dindices[n] - 1;
    }

    @Override
    public final Propagator<?>[] getPropagators() {
        return this.propagators;
    }

    @Override
    public final Propagator<?> getPropagator(int idx) {
        return this.propagators[idx];
    }

    @Override
    public final int getNbProps() {
        return this.dindices[this.dsize];
    }

    @Override
    public final int[] getPIndices() {
        return this.pindices;
    }

    @Override
    public final void setPIndice(int pos, int val) {
        this.pindices[pos] = val;
    }

    @Override
    public final int getDindex(int i) {
        return this.dindices[i];
    }

    @Override
    public final int getIndexInPropagator(int pidx) {
        return this.pindices[pidx];
    }

    @Override
    public int instantiationWorldIndex() {
        return this.isInstantiated() ? this.instWI : Integer.MAX_VALUE;
    }

    @Override
    public void recordWorldIndex() {
        this.instWI = this.model.getEnvironment().getWorldIndex();
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public void notifyPropagators(IEventType event, ICause cause) throws ContradictionException {
        assert (cause != null);
        if (this.isInstantiated()) {
            this.recordWorldIndex();
        }
        this.model.getSolver().getEngine().onVariableUpdate(this, event, cause);
        this.notifyMonitors(event);
        this.notifyViews(event, cause);
    }

    @Override
    public void notifyMonitors(IEventType event) throws ContradictionException {
        for (int i = this.mIdx - 1; i >= 0; --i) {
            this.monitors[i].onUpdate(this, event);
        }
    }

    @Override
    public void notifyViews(IEventType event, ICause cause) throws ContradictionException {
        assert (cause != null);
        if (cause == Cause.Null) {
            for (int i = this.vIdx - 1; i >= 0; --i) {
                this.views[i].notify(event, this.idxInViews[i]);
            }
        } else {
            for (int i = this.vIdx - 1; i >= 0; --i) {
                if (this.views[i] == cause) continue;
                this.views[i].notify(event, this.idxInViews[i]);
            }
        }
    }

    @Override
    public void addMonitor(IVariableMonitor<?> monitor) {
        if (this.model.getSettings().checkDeclaredMonitors()) {
            for (int i = 0; i < this.mIdx; ++i) {
                if (this.monitors[i] != monitor) continue;
                return;
            }
        }
        if (this.mIdx == this.monitors.length) {
            IVariableMonitor[] tmp = this.monitors;
            this.monitors = new IVariableMonitor[tmp.length * 3 / 2 + 1];
            System.arraycopy(tmp, 0, this.monitors, 0, this.mIdx);
        }
        this.monitors[this.mIdx++] = monitor;
    }

    @Override
    public void removeMonitor(IVariableMonitor<?> monitor) {
        int i;
        for (i = this.mIdx - 1; i >= 0 && this.monitors[i] != monitor; --i) {
        }
        if (i < this.mIdx - 1) {
            System.arraycopy(this.monitors, i + 1, this.monitors, i, this.mIdx - (i + 1));
        }
        this.monitors[--this.mIdx] = null;
    }

    @Override
    public void subscribeView(IView<?> view, int idx) {
        if (this.vIdx == this.views.length) {
            IView<?>[] tmp = this.views;
            int[] tmpIdx = this.idxInViews;
            this.views = new IView[tmp.length * 3 / 2 + 1];
            this.idxInViews = new int[tmp.length * 3 / 2 + 1];
            System.arraycopy(tmp, 0, this.views, 0, this.vIdx);
            System.arraycopy(tmpIdx, 0, this.idxInViews, 0, this.vIdx);
        }
        this.views[this.vIdx] = view;
        this.idxInViews[this.vIdx] = idx;
        ++this.vIdx;
    }

    @Override
    public final void contradiction(ICause cause, String message) throws ContradictionException {
        assert (cause != null);
        this.model.getSolver().throwsException(cause, this, message);
    }

    @Override
    public final Model getModel() {
        return this.model;
    }

    @Override
    public int getNbViews() {
        return this.vIdx;
    }

    @Override
    public IView<?> getView(int idx) {
        return this.views[idx];
    }

    @Override
    public int compareTo(Variable o) {
        return this.getId() - o.getId();
    }

    public String toString() {
        return this.getName();
    }

    public final boolean isBool() {
        return (this.getTypeAndKind() & 0x3F8) == 24;
    }

    @Override
    public final boolean isAConstant() {
        return (this.getTypeAndKind() & 7) == 2;
    }

    @Override
    public final EvtScheduler<?> getEvtScheduler() {
        return this.scheduler;
    }

    @Override
    public IntVar asIntVar() {
        return (IntVar)((Object)this);
    }

    @Override
    public BoolVar asBoolVar() {
        return (BoolVar)((Object)this);
    }

    @Override
    public RealVar asRealVar() {
        return (RealVar)((Object)this);
    }

    @Override
    public SetVar asSetVar() {
        return (SetVar)((Object)this);
    }

    @Override
    public void storeEvents(int m, ICause cause) {
        assert (cause != null) : "an event's cause is not supposed to be null";
        if (this.cause == null) {
            this.cause = cause;
        } else if (this.cause != cause) {
            this.cause = Cause.Null;
        }
        this.mask |= m;
    }

    @Override
    public void clearEvents() {
        this.cause = null;
        this.mask = 0;
        this.unschedule();
    }

    @Override
    public int getMask() {
        return this.mask;
    }

    @Override
    public ICause getCause() {
        return this.cause;
    }
}

