/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.variables.impl.siglit;

import org.chocosolver.util.objects.setDataStructures.iterable.IntIterableRangeSet;

public interface SignedLiteral {
    public void add(int var1);

    public void addBetween(int var1, int var2);

    public void addAll(IntIterableRangeSet var1);

    public void retain(int var1);

    public void retainBetween(int var1, int var2);

    public void retainAll(IntIterableRangeSet var1);

    public void clear();

    public IntIterableRangeSet export();

    public boolean isEmpty();

    public boolean disjoint(IntIterableRangeSet var1);

    public static class Set
    implements SignedLiteral {
        IntIterableRangeSet root;
        IntIterableRangeSet lit;

        public Set(IntIterableRangeSet root) {
            this.root = root;
            this.lit = new IntIterableRangeSet();
        }

        @Override
        public void add(int value) {
            if (this.root.contains(value)) {
                this.lit.add(value);
            }
        }

        @Override
        public void addBetween(int lower, int upper) {
            if (this.root.intersect(lower, upper)) {
                this.lit.addBetween(lower, upper);
            }
        }

        @Override
        public void addAll(IntIterableRangeSet set) {
            if (this.root.intersect(set)) {
                this.lit.addAll(set);
            }
        }

        @Override
        public void retain(int value) {
            if (this.root.contains(value)) {
                this.lit.retainBetween(value, value);
            } else {
                this.lit.clear();
            }
        }

        @Override
        public void retainBetween(int lower, int upper) {
            if (this.root.intersect(lower, upper)) {
                this.lit.retainBetween(lower, upper);
            } else {
                this.lit.clear();
            }
        }

        @Override
        public void retainAll(IntIterableRangeSet set) {
            if (this.root.intersect(set)) {
                this.lit.retainAll(set);
            } else {
                this.lit.clear();
            }
        }

        @Override
        public void clear() {
            this.lit.clear();
        }

        @Override
        public IntIterableRangeSet export() {
            this.lit.retainAll(this.root);
            return this.lit.duplicate();
        }

        @Override
        public boolean isEmpty() {
            return this.lit.isEmpty();
        }

        @Override
        public boolean disjoint(IntIterableRangeSet set) {
            return !this.lit.intersect(set);
        }

        public String toString() {
            return this.lit.toString();
        }
    }

    public static class Boolean
    implements SignedLiteral {
        private static final byte bEmpty = 0;
        private static final byte bTrue = 1;
        private static final byte bFalse = 2;
        private static final byte bBoth = 3;
        byte lit;

        @Override
        public void add(int value) {
            int add = 0;
            switch (value) {
                case 0: {
                    add = 2;
                    break;
                }
                case 1: {
                    add = 1;
                }
            }
            this.lit = (byte)(this.lit | add);
        }

        @Override
        public void addBetween(int lower, int upper) {
            if (upper < 0 || lower > 1) {
                return;
            }
            if (lower <= 0) {
                this.lit = (byte)(this.lit | 2);
            }
            if (1 <= upper) {
                this.lit = (byte)(this.lit | 1);
            }
        }

        @Override
        public void addAll(IntIterableRangeSet set) {
            if (set.contains(0)) {
                this.add(0);
            }
            if (set.contains(1)) {
                this.add(1);
            }
        }

        @Override
        public void retain(int value) {
            int keep = 0;
            switch (value) {
                case 0: {
                    keep = 2;
                    break;
                }
                case 1: {
                    keep = 1;
                }
            }
            this.lit = (byte)(this.lit & keep);
        }

        @Override
        public void retainBetween(int lower, int upper) {
            if (upper < 0 || lower > 1) {
                this.lit = 0;
            }
            if (lower > 0) {
                this.lit = (byte)(this.lit & 1);
            }
            if (upper < 1) {
                this.lit = (byte)(this.lit & 2);
            }
        }

        @Override
        public void retainAll(IntIterableRangeSet set) {
            int l = 1;
            int u = 0;
            if (set.contains(0)) {
                l = 0;
            }
            if (set.contains(1)) {
                u = 1;
            }
            this.retainBetween(l, u);
        }

        @Override
        public void clear() {
            this.lit = 0;
        }

        @Override
        public boolean isEmpty() {
            return this.lit == 0;
        }

        @Override
        public boolean disjoint(IntIterableRangeSet set) {
            return this.lit == 1 && !set.contains(1) || this.lit == 2 && !set.contains(0);
        }

        @Override
        public IntIterableRangeSet export() {
            IntIterableRangeSet set = new IntIterableRangeSet();
            switch (this.lit) {
                case 3: {
                    set.addBetween(0, 1);
                    break;
                }
                case 1: {
                    set.add(1);
                    break;
                }
                case 2: {
                    set.add(0);
                }
            }
            return set;
        }

        public String toString() {
            switch (this.lit) {
                default: {
                    return "\u2205";
                }
                case 2: {
                    return "{0}";
                }
                case 1: {
                    return "{1}";
                }
                case 3: 
            }
            return "{0,1}";
        }
    }
}

