/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.graph.connectivity;

import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.DirectedGraphVar;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.ESat;
import org.chocosolver.util.graphOperations.connectivity.StrongConnectivityFinder;
import org.chocosolver.util.objects.graphs.DirectedGraph;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;

public class PropNbSCC
extends Propagator<Variable> {
    private final DirectedGraphVar g;
    private final IntVar k;
    private final StrongConnectivityFinder envCCFinder;
    private final StrongConnectivityFinder kerCCFinder;

    public PropNbSCC(DirectedGraphVar graph, IntVar k) {
        super(new Variable[]{graph, k}, (Priority)PropagatorPriority.LINEAR, false);
        this.g = graph;
        this.k = k;
        this.envCCFinder = new StrongConnectivityFinder((DirectedGraph)this.g.getUB());
        this.kerCCFinder = new StrongConnectivityFinder((DirectedGraph)this.g.getLB());
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        this.k.updateLowerBound(0, this);
        if (this.g.getPotentialNodes().size() == 0) {
            this.k.instantiateTo(0, this);
            return;
        }
        if (this.k.getUB() == 0) {
            ISetIterator iSetIterator = this.g.getPotentialNodes().iterator();
            while (iSetIterator.hasNext()) {
                int i = (Integer)iSetIterator.next();
                this.g.removeNode(i, this);
            }
            return;
        }
        int min = this.minCC();
        int max = this.maxCC();
        this.k.updateLowerBound(min, this);
        this.k.updateUpperBound(max, this);
        if (this.k.getUB() == min && min != max) {
            int ccs = this.envCCFinder.getNbSCC();
            boolean pot = true;
            for (int cc = 0; cc < ccs; ++cc) {
                int i = this.envCCFinder.getSCCFirstNode(cc);
                while (i >= 0 && pot) {
                    if (this.g.getMandatoryNodes().contains(i)) {
                        pot = false;
                    }
                    i = this.envCCFinder.getNextNode(i);
                }
                if (!pot) continue;
                i = this.envCCFinder.getSCCFirstNode(cc);
                while (i >= 0) {
                    this.g.removeNode(i, this);
                    i = this.envCCFinder.getNextNode(i);
                }
            }
        }
    }

    public int minCC() {
        this.envCCFinder.findAllSCC();
        int ccs = this.envCCFinder.getNbSCC();
        int minCC = 0;
        block0: for (int cc = 0; cc < ccs; ++cc) {
            int i = this.envCCFinder.getSCCFirstNode(cc);
            while (i >= 0) {
                if (this.g.getMandatoryNodes().contains(i)) {
                    ++minCC;
                    continue block0;
                }
                i = this.envCCFinder.getNextNode(i);
            }
        }
        return minCC;
    }

    public int maxCC() {
        this.kerCCFinder.findAllSCC();
        int nbK = this.kerCCFinder.getNbSCC();
        int delta = this.g.getPotentialNodes().size() - this.g.getMandatoryNodes().size();
        return nbK + delta;
    }

    @Override
    public ESat isEntailed() {
        if (this.k.getUB() < this.minCC() || this.k.getLB() > this.maxCC()) {
            return ESat.FALSE;
        }
        if (this.isCompletelyInstantiated()) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }
}

