% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conda.R
\name{conda-tools}
\alias{conda-tools}
\alias{conda_list}
\alias{conda_create}
\alias{conda_remove}
\alias{conda_install}
\alias{conda_binary}
\alias{conda_version}
\alias{conda_python}
\title{Interface to conda}
\usage{
conda_list(conda = "auto")

conda_create(
  envname = NULL,
  packages = "python",
  forge = TRUE,
  channel = character(),
  conda = "auto"
)

conda_remove(envname, packages = NULL, conda = "auto")

conda_install(
  envname = NULL,
  packages,
  forge = TRUE,
  channel = character(),
  pip = FALSE,
  pip_options = character(),
  pip_ignore_installed = FALSE,
  conda = "auto",
  python_version = NULL,
  ...
)

conda_binary(conda = "auto")

conda_version(conda = "auto")

conda_python(envname = NULL, conda = "auto")
}
\arguments{
\item{conda}{The path to a \code{conda} executable. Use \code{"auto"} to allow \code{reticulate} to
automatically find an appropriate \code{conda} binary. See \strong{Finding Conda} for more details.}

\item{envname}{The name of, or path to, a conda environment.}

\item{packages}{A character vector, indicating package names which should be installed or removed.}

\item{forge}{Boolean; include the \href{https://conda-forge.org/}{Conda Forge}
repository?}

\item{channel}{An optional character vector of Conda channels to include.
When specified, the \code{forge} argument is ignored. If you need to
specify multiple channels, including the Conda Forge, you can use
\verb{c("conda-forge", <other channels>)}.}

\item{pip}{Boolean; use \code{pip} when downloading or installing packages? Defaults to \code{FALSE}.}

\item{pip_options}{An optional character vector of additional command line
arguments to be passed to \code{pip} if \code{pip} is used.}

\item{pip_ignore_installed}{Ignore installed versions when using pip. This is
\code{TRUE} by default so that specific package versions can be installed even
if they are downgrades. The \code{FALSE} option is useful for situations where
you don't want a pip install to attempt an overwrite of a conda binary
package (e.g. SciPy on Windows which is very difficult to install via pip
due to compilation requirements).}

\item{...}{Optional arguments, reserved for future expansion.}
}
\value{
\code{conda_list()} returns a data frame with the names and paths to the
respective python binaries of available environments. \code{conda_create()}
returns the path to the python binary of the created environment.
\code{conda_binary()} returns the location of the main conda binary or \code{NULL}
if none can be found.
}
\description{
R functions for managing Python \href{https://conda.io/docs/user-guide/tasks/manage-environments.html}{conda environments}.
}
\section{Finding Conda}{


When \code{conda = "auto"}, \code{reticulate} will attempt to automatically find an
Anaconda / Miniconda installation and use that. \code{reticulate} will search the
following locations:
\enumerate{
\item The location specified by the \code{reticulate.conda_binary} \R option;
\item The program \code{PATH};
\item A set of pre-defined locations where Conda is typically installed.
}
}

\keyword{internal}
